/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;

public final class OrderedCompletableFuture<V>
extends CompletableFuture<V> {
    final Queue<BiConsumer<? super V, ? super Throwable>> actions = new ConcurrentLinkedQueue<BiConsumer<? super V, ? super Throwable>>();
    final CompletableFuture<V> parentFuture;

    public OrderedCompletableFuture(CompletableFuture<V> parentFuture) {
        this.parentFuture = parentFuture;
        parentFuture.whenComplete((T r, U e) -> this.invokeActions((V)r, (Throwable)e));
    }

    void invokeActions(V r, Throwable e) {
        BiConsumer<V, Throwable> action;
        while ((action = this.actions.poll()) != null) {
            action.accept(r, e);
        }
    }

    void invokeActions() {
        try {
            V r = this.parentFuture.getNow(null);
            this.invokeActions(r, null);
        }
        catch (CompletionException e) {
            this.invokeActions(null, e.getCause());
        }
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        this.actions.add(action);
        if (this.parentFuture.isDone()) {
            this.invokeActions();
        }
        return this;
    }

    @Override
    public V getNow(V valueIfAbsent) {
        return this.parentFuture.getNow(valueIfAbsent);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.parentFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean complete(V value) {
        return this.parentFuture.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.parentFuture.completeExceptionally(ex);
    }

    @Override
    public boolean isDone() {
        return this.parentFuture.isDone();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.parentFuture.isCompletedExceptionally();
    }

    @Override
    public boolean isCancelled() {
        return this.parentFuture.isCancelled();
    }

    @Override
    public V join() {
        return this.parentFuture.join();
    }
}

