/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.Kryo5Codec;

public class LZ4Codec
extends BaseCodec {
    private static final int DECOMPRESSION_HEADER_SIZE = 4;
    private final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            int decompressSize = buf.readInt();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(decompressSize);
            try {
                LZ4SafeDecompressor decompressor = LZ4Codec.this.factory.safeDecompressor();
                ByteBuffer outBuffer = out.internalNioBuffer(out.writerIndex(), out.writableBytes());
                int pos = outBuffer.position();
                decompressor.decompress(buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()), outBuffer);
                int compressedLength = outBuffer.position() - pos;
                out.writerIndex(compressedLength);
                Object object = LZ4Codec.this.innerCodec.getValueDecoder().decode(out, state);
                return object;
            }
            finally {
                out.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ReferenceCounted bytes = null;
            try {
                LZ4Compressor compressor = LZ4Codec.this.factory.fastCompressor();
                bytes = LZ4Codec.this.innerCodec.getValueEncoder().encode(in);
                ByteBuffer srcBuf = ((ByteBuf)bytes).internalNioBuffer(((ByteBuf)bytes).readerIndex(), ((ByteBuf)bytes).readableBytes());
                int outMaxLength = compressor.maxCompressedLength(((ByteBuf)bytes).readableBytes());
                ByteBuf out = ByteBufAllocator.DEFAULT.buffer(outMaxLength + 4);
                out.writeInt(((ByteBuf)bytes).readableBytes());
                ByteBuffer outBuf = out.internalNioBuffer(out.writerIndex(), out.writableBytes());
                int pos = outBuf.position();
                compressor.compress(srcBuf, outBuf);
                int compressedLength = outBuf.position() - pos;
                out.writerIndex(out.writerIndex() + compressedLength);
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            finally {
                if (bytes != null) {
                    bytes.release();
                }
            }
        }
    };

    public LZ4Codec() {
        this(new Kryo5Codec());
    }

    public LZ4Codec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public LZ4Codec(ClassLoader classLoader) {
        this(new Kryo5Codec(classLoader));
    }

    public LZ4Codec(ClassLoader classLoader, LZ4Codec codec) throws ReflectiveOperationException {
        this(LZ4Codec.copy(classLoader, codec.innerCodec));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

