/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.type.TypeFactory;

public class JsonJackson3Codec
extends BaseCodec {
    public static final JsonJackson3Codec INSTANCE = new JsonJackson3Codec();
    final ObjectMapper mapObjectMapper;
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                JsonJackson3Codec.this.mapObjectMapper.writeValue((OutputStream)os, in);
                return os.buffer();
            }
            catch (Exception e) {
                out.release();
                throw e;
            }
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            return JsonJackson3Codec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Object.class);
        }
    };

    public JsonJackson3Codec() {
        this.mapObjectMapper = this.createDefaultMapper();
    }

    public JsonJackson3Codec(ClassLoader classLoader) {
        this.mapObjectMapper = this.createDefaultMapper(classLoader);
    }

    public JsonJackson3Codec(ClassLoader classLoader, JsonJackson3Codec codec) {
        this(JsonJackson3Codec.createMapper(classLoader, codec.mapObjectMapper.rebuild().build()));
    }

    public JsonJackson3Codec(ObjectMapper mapObjectMapper) {
        this.mapObjectMapper = mapObjectMapper;
    }

    public JsonJackson3Codec(ObjectMapper mapObjectMapper, boolean copy) {
        this.mapObjectMapper = copy ? mapObjectMapper.rebuild().build() : mapObjectMapper;
    }

    protected void initTypeInclusion(JsonMapper.Builder builder) {
        BasicPolymorphicTypeValidator typeValidator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).allowIfSubType(Object.class).build();
        builder.activateDefaultTypingAsProperty((PolymorphicTypeValidator)typeValidator, DefaultTyping.NON_FINAL, "@class");
    }

    protected ObjectMapper createDefaultMapper() {
        return this.createDefaultMapper(null);
    }

    protected ObjectMapper createDefaultMapper(ClassLoader classLoader) {
        TypeFactory typeFactory = TypeFactory.createDefaultInstance();
        if (classLoader != null) {
            typeFactory = typeFactory.withClassLoader(classLoader);
        }
        JsonMapper.Builder b = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().typeFactory(typeFactory)).changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL).withContentInclusion(JsonInclude.Include.NON_NULL))).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER})).disable(new StreamWriteFeature[]{StreamWriteFeature.AUTO_CLOSE_TARGET})).addMixIn(UUID.class, UuidMixin.class);
        this.initTypeInclusion(b);
        return b.build();
    }

    protected static ObjectMapper createMapper(ClassLoader classLoader, ObjectMapper existingMapper) {
        TypeFactory typeFactory = existingMapper.getTypeFactory();
        if (classLoader != null) {
            typeFactory = typeFactory.withClassLoader(classLoader);
        }
        return existingMapper.rebuild().typeFactory(typeFactory).build();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapObjectMapper;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        TypeFactory tf = this.mapObjectMapper.getTypeFactory();
        if (tf.getClassLoader() != null) {
            return tf.getClassLoader();
        }
        return super.getClassLoader();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static abstract class UuidMixin {
        @JsonValue
        public abstract String toString();

        @JsonCreator
        public static UUID fromString(String value) {
            if (value != null) {
                return UUID.fromString(value);
            }
            return null;
        }
    }
}

