/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Set;

public class CustomObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private Set<String> allowedClasses;

    public CustomObjectInputStream(ClassLoader classLoader, InputStream in, Set<String> allowedClasses) throws IOException {
        super(in);
        this.classLoader = classLoader;
        this.allowedClasses = allowedClasses;
    }

    public CustomObjectInputStream(ClassLoader classLoader, InputStream in) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            String name = desc.getName();
            if (this.allowedClasses != null && !this.allowedClasses.contains(name)) {
                throw new InvalidClassException("Class " + name + " isn't allowed");
            }
            return Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ArrayList loadedClasses = new ArrayList(interfaces.length);
        for (String name : interfaces) {
            Class<?> clazz = Class.forName(name, false, this.classLoader);
            loadedClasses.add(clazz);
        }
        return Proxy.getProxyClass(this.classLoader, loadedClasses.toArray(new Class[0]));
    }
}

