/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.codec.JsonJackson3Codec;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.avro.AvroFactory;
import tools.jackson.dataformat.avro.AvroMapper;
import tools.jackson.dataformat.avro.AvroSchema;

public class AvroJackson3Codec
extends JsonJackson3Codec {
    public AvroJackson3Codec(Class<?> type, AvroSchema schema) {
        super((ObjectMapper)new AvroExtendedMapper(type, schema));
    }

    public AvroJackson3Codec(ClassLoader classLoader) {
        super(AvroJackson3Codec.createMapper(classLoader, new ObjectMapper((TokenStreamFactory)new AvroFactory())));
    }

    public AvroJackson3Codec(ClassLoader classLoader, AvroJackson3Codec codec) {
        super(AvroJackson3Codec.createMapper(classLoader, codec.mapObjectMapper.rebuild().build()));
    }

    @Override
    protected void initTypeInclusion(JsonMapper.Builder builder) {
    }

    public static class AvroExtendedMapper
    extends AvroMapper {
        private static final long serialVersionUID = -560070554221164163L;
        private final AvroSchema schema;
        private final Class<?> type;

        public AvroExtendedMapper(Class<?> type, AvroSchema schema) {
            this.type = type;
            this.schema = schema;
        }

        public void writeValue(OutputStream out, Object value) throws JacksonException {
            this.writerFor(this.type).with((FormatSchema)this.schema).writeValue(out, value);
        }

        public byte[] writeValueAsBytes(Object value) throws JacksonException {
            return this.writerFor(this.type).with((FormatSchema)this.schema).writeValueAsBytes(value);
        }

        public <T> T readValue(InputStream src, Class<T> valueType) throws JacksonException {
            return (T)this.readerFor(this.type).with((FormatSchema)this.schema).readValue(src);
        }
    }
}

