/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ContainsSetDecoder<T>
implements MultiDecoder<Set<T>> {
    private final List<T> args;

    public ContainsSetDecoder(Collection<T> args) {
        this.args = args instanceof List ? (List<Object>)args : new ArrayList<T>(args);
    }

    @Override
    public Set<T> decode(List<Object> parts, State state) {
        if (parts.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(parts.size());
        for (int index = 0; index < parts.size(); ++index) {
            Long value = (Long)parts.get(index);
            if (value != 1L) continue;
            result.add(this.args.get(index));
        }
        return result;
    }
}

