/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.List;
import org.redisson.api.bloomfilter.BloomFilterInfo;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class BloomFilterInfoDecoder
implements MultiDecoder<BloomFilterInfo> {
    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
        return LongCodec.INSTANCE.getValueDecoder();
    }

    @Override
    public BloomFilterInfo decode(List<Object> parts, State state) {
        Long capacity = null;
        Long size = null;
        Long subFilterCount = null;
        Long itemCount = null;
        Long expansionRate = null;
        for (int i = 0; i < parts.size(); i += 2) {
            String key = (String)parts.get(i);
            Long value = (Long)parts.get(i + 1);
            if (key.toLowerCase().contains("capacity")) {
                capacity = value;
                continue;
            }
            if (key.toLowerCase().contains("size")) {
                size = value;
                continue;
            }
            if (key.toLowerCase().contains("number of filters")) {
                subFilterCount = value;
                continue;
            }
            if (key.toLowerCase().contains("number of items inserted")) {
                itemCount = value;
                continue;
            }
            if (!key.toLowerCase().contains("expansion rate")) continue;
            expansionRate = value;
        }
        return new BloomFilterInfo(capacity, size, subFilterCount, itemCount, expansionRate);
    }
}

