/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonShardedTopic;
import org.redisson.RedissonTopic;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.LocalCacheInvalidateListener;
import org.redisson.api.listener.LocalCacheUpdateListener;
import org.redisson.api.listener.PatternStatusListener;
import org.redisson.cache.CacheKey;
import org.redisson.cache.CacheValue;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisableAck;
import org.redisson.cache.LocalCachedMapDisabledKey;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.BatchService;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalCacheListener {
    public static final String TOPIC_SUFFIX = "topic";
    public static final String DISABLED_KEYS_SUFFIX = "disabled-keys";
    public static final String DISABLED_ACK_SUFFIX = ":topic";
    private ConcurrentMap<CacheKey, String> disabledKeys = new ConcurrentHashMap<CacheKey, String>();
    private static final Logger log = LoggerFactory.getLogger(LocalCacheListener.class);
    String name;
    CommandAsyncExecutor commandExecutor;
    private Map<CacheKey, ? extends CacheValue> cache;
    private Map<Object, CacheKey> cacheKeyMap;
    private RObject object;
    byte[] instanceId;
    private Codec codec;
    private LocalCachedMapOptions<?, ?> options;
    private final String keyeventPattern;
    private long cacheUpdateLogTime;
    private volatile long lastInvalidate;
    private RTopic invalidationTopic;
    private RPatternTopic patternTopic;
    private int syncListenerId;
    private int reconnectionListenerId;
    private int expireListenerId;
    private final Map<Integer, LocalCacheInvalidateListener<?, ?>> invalidateListeners = new ConcurrentHashMap();
    private final Map<Integer, LocalCacheUpdateListener<?, ?>> updateListeners = new ConcurrentHashMap();
    private boolean isSharded;

    public LocalCacheListener(String name, CommandAsyncExecutor commandExecutor, RObject object, Codec codec, LocalCachedMapOptions<?, ?> options, long cacheUpdateLogTime, boolean isSharded) {
        this.name = name;
        this.commandExecutor = commandExecutor;
        this.object = object;
        this.codec = codec;
        this.options = options;
        this.cacheUpdateLogTime = cacheUpdateLogTime;
        this.isSharded = isSharded;
        this.keyeventPattern = "__keyspace@" + commandExecutor.getServiceManager().getConfig().getDatabase() + "__:" + name;
        this.instanceId = commandExecutor.getServiceManager().generateIdArray();
    }

    public byte[] getInstanceId() {
        return this.instanceId;
    }

    public boolean isDisabled(Object key) {
        return this.disabledKeys.containsKey(key);
    }

    public void add(Map<CacheKey, ? extends CacheValue> cache, Map<Object, CacheKey> cacheKeyMap) {
        Object topic;
        this.cache = cache;
        this.cacheKeyMap = cacheKeyMap;
        this.createTopic(this.name, this.commandExecutor);
        if (this.options.getExpirationEventPolicy() == LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYEVENT_PATTERN) {
            topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
            this.expireListenerId = topic.addListener(String.class, (pattern, channel, msg) -> {
                if (msg.equals(this.name)) {
                    cache.clear();
                    if (this.options.isUseObjectAsCacheKey()) {
                        cacheKeyMap.clear();
                    }
                }
            });
        } else if (this.options.getExpirationEventPolicy() == LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYSPACE_CHANNEL) {
            topic = new RedissonTopic((Codec)StringCodec.INSTANCE, this.commandExecutor, this.keyeventPattern);
            this.expireListenerId = topic.addListener(String.class, (channel, msg) -> {
                if (msg.equals("expired")) {
                    cache.clear();
                    if (this.options.isUseObjectAsCacheKey()) {
                        cacheKeyMap.clear();
                    }
                }
            });
        }
        if (this.options.getReconnectionStrategy() != LocalCachedMapOptions.ReconnectionStrategy.NONE) {
            this.reconnectionListenerId = this.addReconnectionListener();
        }
        if (this.options.getSyncStrategy() != LocalCachedMapOptions.SyncStrategy.NONE) {
            this.syncListenerId = this.addMessageListener();
            if (this.commandExecutor instanceof BatchService) {
                return;
            }
            String disabledKeysName = RedissonObject.suffixName(this.name, DISABLED_KEYS_SUFFIX);
            CompositeCodec localCacheCodec = new CompositeCodec(LocalCachedMessageCodec.INSTANCE, StringCodec.INSTANCE, StringCodec.INSTANCE);
            RedissonListMultimapCache multimap = new RedissonListMultimapCache(null, localCacheCodec, this.commandExecutor, disabledKeysName);
            for (LocalCachedMapDisabledKey key : multimap.readAllKeySet()) {
                HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
                for (String hash : multimap.getAll(key)) {
                    CacheKey cacheKey = new CacheKey(ByteBufUtil.decodeHexDump(hash));
                    keysToDisable.add(cacheKey);
                }
                this.disableKeys(key.getRequestId(), keysToDisable, key.getTimeout());
            }
        }
    }

    void createTopic(String name, CommandAsyncExecutor commandExecutor) {
        this.invalidationTopic = this.isSharded && !this.options.isUseTopicPattern() ? RedissonShardedTopic.createRaw(LocalCachedMessageCodec.INSTANCE, commandExecutor, this.getInvalidationTopicName()) : RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, commandExecutor, this.getInvalidationTopicName());
        if (this.options.isUseTopicPattern()) {
            this.patternTopic = new RedissonPatternTopic(LocalCachedMessageCodec.INSTANCE, commandExecutor, "*:topic");
        }
    }

    int addMessageListener() {
        if (this.patternTopic != null) {
            return this.patternTopic.addListener(Object.class, (pattern, channel, msg) -> {
                if (!this.getInvalidationTopicName().equals(channel.toString())) {
                    return;
                }
                this.onMessage(msg);
            });
        }
        return this.invalidationTopic.addListener(Object.class, (channel, msg) -> this.onMessage(msg));
    }

    int addReconnectionListener() {
        if (this.patternTopic != null) {
            return this.patternTopic.addListener(new PatternStatusListener(){

                @Override
                public void onPSubscribe(String pattern) {
                    LocalCacheListener.this.onSubscribe();
                }

                @Override
                public void onPUnsubscribe(String pattern) {
                }
            });
        }
        return this.invalidationTopic.addListener(new BaseStatusListener(){

            @Override
            public void onSubscribe(String channel) {
                LocalCacheListener.this.onSubscribe();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(Object msg) {
        LocalCachedMapUpdate updateMsg;
        LocalCachedMapInvalidate invalidateMsg;
        LocalCachedMapClear clearMsg;
        Serializable m;
        if (msg instanceof LocalCachedMapDisable) {
            m = (LocalCachedMapDisable)msg;
            String requestId = ((LocalCachedMapDisable)m).getRequestId();
            HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
            for (byte[] keyHash : ((LocalCachedMapDisable)msg).getKeyHashes()) {
                CacheKey key = new CacheKey(keyHash);
                keysToDisable.add(key);
            }
            this.disableKeys(requestId, keysToDisable, ((LocalCachedMapDisable)m).getTimeout());
            RedissonTopic topic = RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, RedissonObject.suffixName(this.name, (String)requestId + DISABLED_ACK_SUFFIX));
            topic.publishAsync(new LocalCachedMapDisableAck());
        }
        if (msg instanceof LocalCachedMapEnable) {
            m = (LocalCachedMapEnable)msg;
            for (Object keyHash : (String)((LocalCachedMapEnable)m).getKeyHashes()) {
                CacheKey key = new CacheKey((byte[])keyHash);
                this.disabledKeys.remove(key, ((LocalCachedMapEnable)m).getRequestId());
            }
        }
        if (msg instanceof LocalCachedMapClear && !Arrays.equals((clearMsg = (LocalCachedMapClear)msg).getExcludedId(), this.instanceId)) {
            this.cache.clear();
            if (this.options.isUseObjectAsCacheKey()) {
                this.cacheKeyMap.clear();
            }
            if (clearMsg.isReleaseSemaphore()) {
                RSemaphore semaphore = this.getClearSemaphore(clearMsg.getRequestId());
                semaphore.releaseIfExistsAsync(1);
            }
        }
        if (msg instanceof LocalCachedMapInvalidate && !Arrays.equals((invalidateMsg = (LocalCachedMapInvalidate)msg).getExcludedId(), this.instanceId)) {
            for (byte[] keyHash : invalidateMsg.getKeyHashes()) {
                CacheKey key = new CacheKey(keyHash);
                CacheValue value = this.cache.remove(key);
                if (value == null) continue;
                if (this.options.isUseObjectAsCacheKey()) {
                    this.cacheKeyMap.remove(value.getKey());
                }
                this.notifyInvalidate(value);
            }
        }
        if (msg instanceof LocalCachedMapUpdate && !Arrays.equals((updateMsg = (LocalCachedMapUpdate)msg).getExcludedId(), this.instanceId)) {
            Object object = updateMsg.getEntries().iterator();
            while (object.hasNext()) {
                LocalCachedMapUpdate.Entry entry = (LocalCachedMapUpdate.Entry)object.next();
                ByteBuf keyBuf = Unpooled.wrappedBuffer(entry.getKey());
                ByteBuf valueBuf = Unpooled.wrappedBuffer(entry.getValue());
                try {
                    CacheValue value = this.updateCache(keyBuf, valueBuf);
                    this.notifyUpdate(value);
                }
                catch (IOException e) {
                    log.error("Can't decode map entry", e);
                }
                finally {
                    keyBuf.release();
                    valueBuf.release();
                }
            }
        }
        if (this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD) {
            this.lastInvalidate = System.currentTimeMillis();
        }
    }

    final void onSubscribe() {
        if (this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.CLEAR) {
            this.cache.clear();
            if (this.options.isUseObjectAsCacheKey()) {
                this.cacheKeyMap.clear();
            }
        }
        if (this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD && this.lastInvalidate > 0L) {
            this.loadAfterReconnection();
        }
    }

    public void notifyUpdate(CacheValue value) {
        for (LocalCacheUpdateListener<?, ?> listener : this.updateListeners.values()) {
            listener.onUpdate(value.getKey(), value.getValue());
        }
    }

    public void notifyInvalidate(CacheValue value) {
        for (LocalCacheInvalidateListener<?, ?> listener : this.invalidateListeners.values()) {
            listener.onInvalidate(value.getKey(), value.getValue());
        }
    }

    public RFuture<Void> clearLocalCacheAsync() {
        this.cache.clear();
        if (this.options.isUseObjectAsCacheKey()) {
            this.cacheKeyMap.clear();
        }
        if (this.syncListenerId == 0) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        byte[] id = this.commandExecutor.getServiceManager().generateIdArray();
        RSemaphore semaphore = this.getClearSemaphore(id);
        CompletionStage f = semaphore.trySetPermitsAsync(0, Duration.ofSeconds(60L)).thenCompose(r -> this.publishAsync(id)).thenCompose(res -> {
            if (res == 0L) {
                return semaphore.deleteAsync().thenApply(r -> null);
            }
            return semaphore.tryAcquireAsync(res.intValue() - 1, 40L, TimeUnit.SECONDS).thenCompose(r -> semaphore.deleteAsync().thenApply(re -> null));
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    RFuture<Long> publishAsync(byte[] id) {
        return this.publishAsync(new LocalCachedMapClear(this.instanceId, id, true));
    }

    public RFuture<Long> publishAsync(Object msg) {
        return this.invalidationTopic.publishAsync(msg);
    }

    public String getPublishCommand() {
        if (this.isSharded && !this.options.isUseTopicPattern()) {
            return RedisCommands.SPUBLISH.getName();
        }
        return RedisCommands.PUBLISH.getName();
    }

    public String getInvalidationTopicName() {
        return RedissonObject.suffixName(this.name, TOPIC_SUFFIX);
    }

    protected abstract CacheValue updateCache(ByteBuf var1, ByteBuf var2) throws IOException;

    private void disableKeys(String requestId, Set<CacheKey> keys, long timeout) {
        for (CacheKey key : keys) {
            this.disabledKeys.put(key, requestId);
            CacheValue cacheValue = this.cache.remove(key);
            if (!this.options.isUseObjectAsCacheKey() || cacheValue == null) continue;
            this.cacheKeyMap.remove(cacheValue.getValue());
        }
        this.commandExecutor.getServiceManager().newTimeout(t -> {
            for (CacheKey cacheKey : keys) {
                this.disabledKeys.remove(cacheKey, requestId);
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    public void remove() {
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        if (this.syncListenerId != 0) {
            ids.add(this.syncListenerId);
        }
        if (this.reconnectionListenerId != 0) {
            ids.add(this.reconnectionListenerId);
        }
        this.removeAsync(ids);
        if (this.options.getExpirationEventPolicy() == LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYEVENT_PATTERN) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
            topic.removeListenerAsync(this.expireListenerId);
        } else if (this.options.getExpirationEventPolicy() == LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYSPACE_CHANNEL) {
            RedissonTopic topic = new RedissonTopic((Codec)StringCodec.INSTANCE, this.commandExecutor, this.keyeventPattern);
            topic.removeListenerAsync(this.expireListenerId);
        }
    }

    void removeAsync(List<Integer> ids) {
        if (this.patternTopic != null) {
            this.patternTopic.removeListenerAsync(ids.toArray(new Integer[0]));
            return;
        }
        this.invalidationTopic.removeListenerAsync(ids.toArray(new Integer[0]));
    }

    public String getUpdatesLogName() {
        return RedissonObject.prefixName("redisson__cache_updates_log", this.name);
    }

    private void loadAfterReconnection() {
        if (System.currentTimeMillis() - this.lastInvalidate > this.cacheUpdateLogTime) {
            this.cache.clear();
            if (this.options.isUseObjectAsCacheKey()) {
                this.cacheKeyMap.clear();
            }
            return;
        }
        this.object.isExistsAsync().whenComplete((res, e) -> {
            if (e != null) {
                log.error("Can't check existance", (Throwable)e);
                return;
            }
            if (!res.booleanValue()) {
                this.cache.clear();
                if (this.options.isUseObjectAsCacheKey()) {
                    this.cacheKeyMap.clear();
                }
                return;
            }
            RedissonScoredSortedSet logs = new RedissonScoredSortedSet(ByteArrayCodec.INSTANCE, this.commandExecutor, this.getUpdatesLogName(), null);
            logs.valueRangeAsync(this.lastInvalidate, true, Double.POSITIVE_INFINITY, true).whenComplete((r, ex) -> {
                if (ex != null) {
                    log.error("Can't load update log", (Throwable)ex);
                    return;
                }
                for (byte[] entry : r) {
                    byte[] keyHash = Arrays.copyOf(entry, 16);
                    CacheKey key = new CacheKey(keyHash);
                    CacheValue cacheValue = this.cache.remove(key);
                    if (!this.options.isUseObjectAsCacheKey() || cacheValue == null) continue;
                    this.cacheKeyMap.remove(cacheValue.getValue());
                }
            });
        });
    }

    private RSemaphore getClearSemaphore(byte[] requestId) {
        String id = ByteBufUtil.hexDump(requestId);
        return new RedissonSemaphore(this.commandExecutor, this.name + ":clear:" + id);
    }

    public <K, V> int addListener(LocalCacheInvalidateListener<K, V> listener) {
        int listenerId = System.identityHashCode(listener);
        this.invalidateListeners.put(listenerId, listener);
        return listenerId;
    }

    public <K, V> int addListener(LocalCacheUpdateListener<K, V> listener) {
        int listenerId = System.identityHashCode(listener);
        this.updateListeners.put(listenerId, listener);
        return listenerId;
    }

    public void removeListener(int listenerId) {
        this.updateListeners.remove(listenerId);
        this.invalidateListeners.remove(listenerId);
    }
}

