/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.aggregate;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.api.search.aggregate.Expression;
import org.redisson.api.search.aggregate.GroupBy;
import org.redisson.api.search.aggregate.GroupParams;
import org.redisson.api.search.aggregate.SortedField;

public class AggregationBaseOptions<T> {
    private boolean verbatim;
    private List<String> load = Collections.emptyList();
    private Long timeout;
    private boolean loadAll;
    private List<GroupParams> groupByParams = Collections.emptyList();
    private List<SortedField> sortedByFields = Collections.emptyList();
    private Integer sortedByMax;
    private boolean sortedByWithCount;
    private List<Expression> expressions = Collections.emptyList();
    private Integer offset;
    private Integer count;
    private String filter;
    protected boolean withCursor;
    protected Integer cursorCount;
    protected Duration cursorMaxIdle;
    private Map<String, Object> params = Collections.emptyMap();
    private Integer dialect;

    protected AggregationBaseOptions() {
    }

    public T verbatim(boolean verbatim) {
        this.verbatim = verbatim;
        return (T)this;
    }

    public T load(String ... attributes) {
        this.load = Arrays.asList(attributes);
        return (T)this;
    }

    public T timeout(Long timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public T loadAll() {
        this.loadAll = true;
        return (T)this;
    }

    public T groupBy(GroupBy ... groups) {
        this.groupByParams = Arrays.stream(groups).map(g -> (GroupParams)g).collect(Collectors.toList());
        return (T)this;
    }

    public T sortBy(SortedField ... fields) {
        this.sortedByFields = Arrays.asList(fields);
        return (T)this;
    }

    public T sortBy(int max, SortedField ... fields) {
        this.sortedByMax = max;
        this.sortedByFields = Arrays.asList(fields);
        return (T)this;
    }

    public T sortBy(boolean withCount, SortedField ... fields) {
        this.sortedByWithCount = withCount;
        this.sortedByFields = Arrays.asList(fields);
        return (T)this;
    }

    public T sortBy(int max, boolean withCount, SortedField ... fields) {
        this.sortedByMax = max;
        this.sortedByWithCount = withCount;
        this.sortedByFields = Arrays.asList(fields);
        return (T)this;
    }

    public T apply(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
        return (T)this;
    }

    public T limit(int offset, int count) {
        this.offset = offset;
        this.count = count;
        return (T)this;
    }

    public T filter(String filter) {
        this.filter = filter;
        return (T)this;
    }

    protected T cursorCount(int count) {
        this.cursorCount = count;
        return (T)this;
    }

    protected T withCursor() {
        this.withCursor = true;
        return (T)this;
    }

    protected T cursorMaxIdle(Duration duration) {
        this.cursorMaxIdle = duration;
        return (T)this;
    }

    public T params(Map<String, Object> params) {
        this.params = params;
        return (T)this;
    }

    public T dialect(Integer dialect) {
        this.dialect = dialect;
        return (T)this;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public List<String> getLoad() {
        return this.load;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public boolean isLoadAll() {
        return this.loadAll;
    }

    public List<GroupParams> getGroupByParams() {
        return this.groupByParams;
    }

    public List<SortedField> getSortedByFields() {
        return this.sortedByFields;
    }

    public Integer getSortedByMax() {
        return this.sortedByMax;
    }

    public boolean isSortedByWithCount() {
        return this.sortedByWithCount;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isWithCursor() {
        return this.withCursor;
    }

    public Integer getCursorCount() {
        return this.cursorCount;
    }

    public Duration getCursorMaxIdle() {
        return this.cursorMaxIdle;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Integer getDialect() {
        return this.dialect;
    }
}

