/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.pubsub;

import java.time.Duration;
import org.redisson.api.BaseSyncParams;
import org.redisson.api.pubsub.AcknowledgeMode;
import org.redisson.api.pubsub.MessageListener;
import org.redisson.api.pubsub.MessageListenerArgs;
import org.redisson.client.codec.Codec;

public final class MessageListenerParams<V>
extends BaseSyncParams<MessageListenerArgs<V>>
implements MessageListenerArgs<V> {
    private final MessageListener<V> listener;
    private AcknowledgeMode acknowledgeMode = AcknowledgeMode.MANUAL;
    private Duration visibility = Duration.ofSeconds(30L);
    private Codec headersCodec;

    MessageListenerParams(MessageListener<V> listener) {
        this.listener = listener;
    }

    @Override
    public MessageListenerArgs<V> acknowledgeMode(AcknowledgeMode mode) {
        this.acknowledgeMode = mode;
        return this;
    }

    @Override
    public MessageListenerArgs<V> headersCodec(Codec codec) {
        this.headersCodec = codec;
        return this;
    }

    @Override
    public MessageListenerArgs<V> visibility(Duration value) {
        this.visibility = value;
        return this;
    }

    public Duration getVisibility() {
        return this.visibility;
    }

    public Codec getHeadersCodec() {
        return this.headersCodec;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public MessageListener<V> getListener() {
        return this.listener;
    }
}

