/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.options;

import java.time.Duration;
import org.redisson.api.options.CodecOptions;
import org.redisson.api.options.InvocationOptions;
import org.redisson.api.options.ObjectParams;
import org.redisson.config.ConstantDelay;
import org.redisson.config.DelayStrategy;

class BaseOptions<T extends InvocationOptions<T>, C>
implements CodecOptions<T, C>,
ObjectParams {
    private C codec;
    private int timeout;
    private int retryAttempts = -1;
    private DelayStrategy retryDelay;

    BaseOptions() {
    }

    @Override
    public T codec(C codec) {
        this.codec = codec;
        return (T)this;
    }

    @Override
    public T timeout(Duration timeout) {
        this.timeout = (int)timeout.toMillis();
        return (T)this;
    }

    @Override
    public T retryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return (T)this;
    }

    @Override
    public T retryInterval(Duration interval) {
        this.retryDelay = new ConstantDelay(interval);
        return (T)this;
    }

    @Override
    public T retryDelay(DelayStrategy interval) {
        this.retryDelay = interval;
        return (T)this;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public C getCodec() {
        return this.codec;
    }

    @Override
    public DelayStrategy getRetryDelay() {
        return this.retryDelay;
    }
}

