/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.Redisson;
import org.redisson.RedissonBucket;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonList;
import org.redisson.RedissonLock;
import org.redisson.ScanResult;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonSortedSet<V>
extends RedissonExpirable
implements RSortedSet<V> {
    private Comparator comparator = Comparator.naturalOrder();
    private RLock lock;
    private RedissonList<V> list;
    private RBucket<String> comparatorHolder;
    private RedissonClient redisson;

    protected RedissonSortedSet(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.redisson = redisson;
        this.comparatorHolder = new RedissonBucket<String>(this.getComparatorKeyName(), StringCodec.INSTANCE, commandExecutor);
        this.lock = new RedissonLock(this.getLockName(), commandExecutor);
        this.list = (RedissonList)redisson.getList(this.getName(), this.codec);
    }

    public RedissonSortedSet(Codec codec, CommandAsyncExecutor commandExecutor, String name, Redisson redisson) {
        super(codec, commandExecutor, name);
        this.comparatorHolder = new RedissonBucket<String>(this.getComparatorKeyName(), StringCodec.INSTANCE, commandExecutor);
        this.lock = new RedissonLock(this.getLockName(), commandExecutor);
        this.list = (RedissonList)redisson.getList(this.getName(), codec);
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    private void loadComparator() {
        try {
            String comparatorSign = this.comparatorHolder.get();
            if (comparatorSign != null) {
                String[] parts = comparatorSign.split(":");
                String className = parts[0];
                String sign = parts[1];
                String result = RedissonSortedSet.calcClassSign(className);
                if (!result.equals(sign)) {
                    throw new IllegalStateException("Local class signature of " + className + " differs from used by this SortedSet!");
                }
                Class<?> clazz = Class.forName(className);
                this.comparator = (Comparator)clazz.newInstance();
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String calcClassSign(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(result);
            outputStream.writeObject(clazz);
            outputStream.close();
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(result.toByteArray());
            return new BigInteger(1, crypt.digest()).toString(16);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't calculate sign of " + name, e);
        }
    }

    @Override
    public Collection<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllAsync() {
        return this.list.readAllAsync();
    }

    protected final <T> RFuture<V> wrapLockedAsync(RedisCommand<T> command, Object ... params) {
        return this.wrapLockedAsync(() -> this.commandExecutor.writeAsync(this.list.getRawName(), this.codec, command, params));
    }

    protected final <T, R> RFuture<R> wrapLockedAsync(Supplier<RFuture<R>> callable) {
        long randomId = this.getServiceManager().getRandom().nextLong();
        CompletionStage f = this.lock.lockAsync(randomId).thenCompose(r -> {
            RFuture callback = (RFuture)callable.get();
            return callback.handle((value, ex) -> {
                CompletableFuture result = new CompletableFuture();
                this.lock.unlockAsync(randomId).whenComplete((r2, ex2) -> {
                    if (ex2 != null) {
                        if (ex != null) {
                            ex2.addSuppressed((Throwable)ex);
                        }
                        result.completeExceptionally((Throwable)ex2);
                        return;
                    }
                    if (ex != null) {
                        result.completeExceptionally((Throwable)ex);
                        return;
                    }
                    result.complete(value);
                });
                return result;
            }).thenCompose(ff -> ff);
        });
        return new CompletableFutureWrapper(f);
    }

    protected <T> void takeAsync(CompletableFuture<V> result, long delay, long timeoutInMicro, RedisCommand<T> command, Object ... params) {
        if (result.isDone()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.getServiceManager().newTimeout(t -> {
            if (result.isDone()) {
                return;
            }
            RFuture<V> future = this.wrapLockedAsync(command, params);
            future.whenComplete((res, e) -> {
                if (e != null && !(e instanceof RedisConnectionException)) {
                    result.completeExceptionally((Throwable)e);
                    return;
                }
                if (res != null && !(res instanceof List)) {
                    result.complete(res);
                    return;
                }
                if (res instanceof List && !((List)res).isEmpty()) {
                    result.complete(res);
                    return;
                }
                if (result.isCancelled()) {
                    return;
                }
                long remain = 0L;
                if (timeoutInMicro > 0L && (remain = timeoutInMicro - (System.currentTimeMillis() - start) * 1000L) <= 0L) {
                    result.complete(res);
                    return;
                }
                long del = ThreadLocalRandom.current().nextInt(2000000);
                if (timeoutInMicro > 0L && remain < 2000000L) {
                    del = 0L;
                }
                this.takeAsync(result, del, remain, command, params);
            });
        }, delay, TimeUnit.MICROSECONDS);
    }

    @Override
    public V pollFirst() {
        return this.get(this.pollFirstAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.wrapLockedAsync(RedisCommands.LPOP, this.list.getRawName());
    }

    @Override
    public Collection<V> pollFirst(int count) {
        return this.get(this.pollFirstAsync(count));
    }

    @Override
    public RFuture<Collection<V>> pollFirstAsync(int count) {
        return this.wrapLockedAsync(RedisCommands.LPOP_LIST, this.list.getRawName(), count);
    }

    @Override
    public V pollFirst(Duration duration) {
        return this.get(this.pollFirstAsync(duration));
    }

    @Override
    public RFuture<V> pollFirstAsync(Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, duration.toMillis() * 1000L, RedisCommands.LPOP, this.list.getRawName());
        return new CompletableFutureWrapper(result);
    }

    @Override
    public List<V> pollFirst(Duration duration, int count) {
        return this.get(this.pollFirstAsync(duration, count));
    }

    @Override
    public RFuture<List<V>> pollFirstAsync(Duration duration, int count) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, duration.toMillis() * 1000L, RedisCommands.LPOP_LIST, this.list.getRawName(), count);
        return new CompletableFutureWrapper<List<V>>(result);
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.wrapLockedAsync(RedisCommands.RPOP, this.list.getRawName());
    }

    @Override
    public Collection<V> pollLast(int count) {
        return this.get(this.pollLastAsync(count));
    }

    @Override
    public RFuture<Collection<V>> pollLastAsync(int count) {
        return this.wrapLockedAsync(RedisCommands.RPOP_LIST, this.list.getRawName(), count);
    }

    @Override
    public V pollLast(Duration duration) {
        return this.get(this.pollLastAsync(duration));
    }

    @Override
    public RFuture<V> pollLastAsync(Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, duration.toMillis() * 1000L, RedisCommands.RPOP, this.list.getRawName());
        return new CompletableFutureWrapper(result);
    }

    @Override
    public List<V> pollLast(Duration duration, int count) {
        return this.get(this.pollLastAsync(duration, count));
    }

    @Override
    public RFuture<List<V>> pollLastAsync(Duration duration, int count) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, duration.toMillis() * 1000L, RedisCommands.RPOP_LIST, this.list.getRawName(), count);
        return new CompletableFutureWrapper<List<V>>(result);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.binarySearch(o, this.codec).getIndex() >= 0;
    }

    @Override
    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<V> res = this.binarySearch(value, this.codec);
            if (res.getIndex() < 0) {
                int index = -(res.getIndex() + 1);
                ByteBuf encodedValue = this.encode(value);
                this.commandExecutor.get(this.commandExecutor.evalWriteNoRetryAsync(this.list.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local len = redis.call('llen', KEYS[1]);if tonumber(ARGV[1]) < len then local pivot = redis.call('lindex', KEYS[1], ARGV[1]);redis.call('linsert', KEYS[1], 'before', pivot, ARGV[2]);return;end;redis.call('rpush', KEYS[1], ARGV[2]);", Arrays.asList(this.list.getRawName()), index, encodedValue));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkComparator() {
        String comparatorSign = this.comparatorHolder.get();
        if (comparatorSign != null) {
            String[] vals = comparatorSign.split(":");
            String className = vals[0];
            if (!this.comparator.getClass().getName().equals(className)) {
                this.loadComparator();
            }
        }
    }

    @Override
    public RFuture<Boolean> addAsync(V value) {
        CompletableFuture<Boolean> f = CompletableFuture.supplyAsync(() -> this.add(value), this.getServiceManager().getExecutor());
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object value) {
        CompletableFuture<Boolean> f = CompletableFuture.supplyAsync(() -> this.remove(value), this.getServiceManager().getExecutor());
        return new CompletableFutureWrapper<Boolean>(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<Object> res = this.binarySearch(value, this.codec);
            if (res.getIndex() < 0) {
                boolean bl = false;
                return bl;
            }
            this.list.remove(res.getIndex());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            V object = iterator.next();
            if (c.contains(object)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.subSet((V)null, toElement);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.subSet(fromElement, (V)null);
    }

    @Override
    public V first() {
        Object res = this.list.getValue(0);
        if (res == null) {
            throw new NoSuchElementException();
        }
        return res;
    }

    @Override
    public V last() {
        Object res = this.list.getValue(-1);
        if (res == null) {
            throw new NoSuchElementException();
        }
        return res;
    }

    private String getLockName() {
        return RedissonSortedSet.prefixName("redisson_sortedset_lock", this.getRawName());
    }

    private String getComparatorKeyName() {
        return RedissonSortedSet.prefixName("redisson_sortedset_comparator", this.getRawName());
    }

    @Override
    public boolean trySetComparator(Comparator<? super V> comparator) {
        String className = comparator.getClass().getName();
        String comparatorSign = className + ":" + RedissonSortedSet.calcClassSign(className);
        Boolean res = (Boolean)this.commandExecutor.get(this.commandExecutor.evalWriteAsync(this.list.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('llen', KEYS[1]) == 0 then redis.call('set', KEYS[2], ARGV[1]); return 1; else return 0; end", Arrays.asList(this.list.getRawName(), this.getComparatorKeyName()), comparatorSign));
        if (res.booleanValue()) {
            this.comparator = comparator;
        }
        return res;
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonSortedSet.this.distributedScanIterator(iteratorName, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSortedSet.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, int count) {
        return this.commandExecutor.evalWriteAsync(this.list.getRawName(), this.codec, RedisCommands.EVAL_SCAN, "local start_index = redis.call('get', KEYS[2]); if start_index ~= false then start_index = tonumber(start_index); else start_index = 0;end;if start_index == -1 then return {'0', {}}; end;local end_index = start_index + ARGV[1];local result; result = redis.call('lrange', KEYS[1], start_index, end_index - 1); if end_index > redis.call('llen', KEYS[1]) then end_index = -1;end; redis.call('setex', KEYS[2], 3600, end_index);return {tostring(end_index), result};", Arrays.asList(this.list.getRawName(), iteratorName), count);
    }

    public BinarySearchResult<V> binarySearch(V value, Codec codec) {
        int size = this.list.size();
        int upperIndex = size - 1;
        int lowerIndex = 0;
        while (lowerIndex <= upperIndex) {
            int index = lowerIndex + (upperIndex - lowerIndex) / 2;
            Object res = this.list.getValue(index);
            if (res == null) {
                return new BinarySearchResult();
            }
            int cmp = this.comparator.compare(value, res);
            if (cmp == 0) {
                BinarySearchResult indexRes = new BinarySearchResult();
                indexRes.setIndex(index);
                return indexRes;
            }
            if (cmp < 0) {
                upperIndex = index - 1;
                continue;
            }
            lowerIndex = index + 1;
        }
        BinarySearchResult indexRes = new BinarySearchResult();
        indexRes.setIndex(-(lowerIndex + 1));
        return indexRes;
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getComparatorKeyName(), this.getLockName());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.getComparatorKeyName(), this.getLockName());
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.getComparatorKeyName(), this.getLockName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getComparatorKeyName(), this.getLockName());
    }

    public static class BinarySearchResult<V> {
        private V value;
        private int index = -1;

        public BinarySearchResult(V value) {
            this.value = value;
        }

        public BinarySearchResult() {
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.value;
        }
    }
}

