/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.RedissonTopic;
import org.redisson.api.RFuture;
import org.redisson.api.RShardedTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.NameMapper;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.PubSubConnectionEntry;

public class RedissonShardedTopic
extends RedissonTopic
implements RShardedTopic {
    public RedissonShardedTopic(CommandAsyncExecutor commandExecutor, String ... names) {
        super(commandExecutor, names);
    }

    public RedissonShardedTopic(Codec codec, CommandAsyncExecutor commandExecutor, String ... names) {
        super(codec, commandExecutor, names);
    }

    public RedissonShardedTopic(Codec codec, CommandAsyncExecutor commandExecutor, NameMapper nameMapper, String ... names) {
        super(codec, commandExecutor, nameMapper, names);
    }

    public static RedissonTopic createRaw(Codec codec, CommandAsyncExecutor commandExecutor, String ... names) {
        return new RedissonShardedTopic(codec, commandExecutor, NameMapper.direct(), names);
    }

    @Override
    protected RFuture<Integer> addListenerAsync(RedisPubSubListener<?> pubSubListener) {
        CompletableFuture<PubSubConnectionEntry> future = this.subscribeService.ssubscribe(this.codec, this.channelNames, pubSubListener);
        CompletionStage f = future.thenApply(res -> System.identityHashCode(pubSubListener));
        return new CompletableFutureWrapper<Integer>((CompletableFuture<Integer>)f);
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        String name = this.getName();
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.SPUBLISH, name, this.commandExecutor.encode(this.codec, message));
    }

    @Override
    public RFuture<Void> removeListenerAsync(MessageListener<?> listener) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.SUNSUBSCRIBE, (List<ChannelName>)this.channelNames, listener);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeListenerAsync(Integer ... listenerIds) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.SUNSUBSCRIBE, (List<ChannelName>)this.channelNames, listenerIds);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeAllListenersAsync() {
        CompletableFuture<Void> f = this.subscribeService.removeAllListenersAsync(PubSubType.SUNSUBSCRIBE, this.channelNames.toArray(new ChannelName[0]));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Long> countSubscribersAsync() {
        return this.commandExecutor.writeAsync((String)this.names.get(0), (Codec)LongCodec.INSTANCE, RedisCommands.PUBSUB_SHARDNUMSUB, this.names.toArray());
    }
}

