/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonSemaphore;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.AsyncIterator;
import org.redisson.api.ObjectListener;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.listener.SetAddListener;
import org.redisson.api.listener.SetRemoveListener;
import org.redisson.api.listener.TrackingListener;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.iterator.BaseAsyncIterator;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.CompositeAsyncIterator;

public class RedissonSetCache<V>
extends RedissonExpirable
implements RSetCache<V>,
ScanIterator {
    final RedissonClient redisson;
    final EvictionScheduler evictionScheduler;

    public RedissonSetCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), 0L);
        }
        this.evictionScheduler = evictionScheduler;
        this.redisson = redisson;
    }

    public RedissonSetCache(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), 0L);
        }
        this.evictionScheduler = evictionScheduler;
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2]);return #values;", Arrays.asList(this.getRawName()), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.evalReadAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;end;return 1;end; return 0;", Arrays.asList(name), System.currentTimeMillis(), this.encode(o));
    }

    @Override
    public ScanResult<Object> scanIterator(String name, RedisClient client, String startPos, String pattern, int count) {
        RFuture<ScanResult<Object>> f = this.scanIteratorAsync(name, client, startPos, pattern, count);
        return this.get(f);
    }

    @Override
    public RFuture<ScanResult<Object>> scanIteratorAsync(String name, RedisClient client, String startPos, String pattern, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startPos);
        params.add(System.currentTimeMillis());
        if (pattern != null) {
            params.add(pattern);
        }
        params.add(count);
        return this.commandExecutor.evalReadAsync(client, name, this.codec, RedisCommands.EVAL_SCAN, "local result = {}; local res; if (#ARGV == 4) then  res = redis.call('zscan', KEYS[1], ARGV[1], 'match', ARGV[3], 'count', ARGV[4]); else  res = redis.call('zscan', KEYS[1], ARGV[1], 'count', ARGV[3]); end;for i, value in ipairs(res[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[2]) then table.insert(result, res[2][i-1]); end; end;end;return {res[1], result};", Arrays.asList(name), params.toArray());
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonSetCache.this.scanIterator(RedissonSetCache.this.getRawName(), client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE, this.getRawName(), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean add(V value, long ttl, TimeUnit unit) {
        return this.get(this.addAsync(value, ttl, unit));
    }

    @Override
    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("TTL can't be negative");
        }
        if (ttl == 0L) {
            return this.addAsync(value);
        }
        if (unit == null) {
            throw new NullPointerException("TimeUnit param can't be null");
        }
        ByteBuf objectState = this.encode(value);
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        String name = this.getRawName(value);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; return 1; ", Arrays.asList(name), System.currentTimeMillis(), timeoutDate, objectState);
    }

    @Override
    public boolean tryAdd(V ... values) {
        return this.get(this.tryAddAsync(values));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(V ... values) {
        return this.tryAddAsync(92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS, values);
    }

    @Override
    public boolean tryAdd(long ttl, TimeUnit unit, V ... values) {
        return this.get(this.tryAddAsync(ttl, unit, values));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(long ttl, TimeUnit unit, V ... values) {
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        if (ttl == 0L) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        params.add(Long.valueOf(System.currentTimeMillis()));
        params.add(Long.valueOf(timeoutDate));
        params.addAll(this.encode(Arrays.asList(values)));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for i, v in ipairs(ARGV) do local expireDateScore = redis.call('zscore', KEYS[1], v); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0; end; end; for i=3, #ARGV, 1 do redis.call('zadd', KEYS[1], ARGV[2], ARGV[i]); end; return 1; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Boolean> addAsync(V value) {
        return this.addAsync(value, 92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.ZREM, name, this.encode(o));
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(true);
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() + 1);
        params.add(System.currentTimeMillis());
        this.encode(params, c);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for j = 2, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;end; else return 0;end; end; return 1; ", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getRawName());
        for (V value : c) {
            ByteBuf objectState = this.encode(value);
            params.add(score);
            params.add(objectState);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL_RAW, params.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Long> params = new ArrayList<Long>(c.size() * 2);
        for (Object object : c) {
            params.add(score);
            this.encode(params, object);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], #ARGV/2, KEYS[1], KEYS[2], 'aggregate', 'min');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getRawName(), "redisson_temp__{" + this.getRawName() + "}"), params.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() + 1);
        params.add(this.getRawName());
        this.encode(params, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        String lockName = this.getLockByValue(value, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(V value) {
        String lockName = this.getLockByValue(value, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(V value) {
        String lockName = this.getLockByValue(value, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RLock getFairLock(V value) {
        String lockName = this.getLockByValue(value, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(V value) {
        String lockName = this.getLockByValue(value, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(V value) {
        String lockName = this.getLockByValue(value, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    @Override
    public void destroy() {
        if (this.evictionScheduler != null) {
            this.evictionScheduler.remove(this.getRawName());
        }
        this.removeListeners();
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }

    @Override
    public int addAllCounted(Collection<? extends V> c) {
        return this.get(this.addAllCountedAsync(c));
    }

    @Override
    public int removeAllCounted(Collection<? extends V> c) {
        return this.get(this.removeAllCountedAsync(c));
    }

    @Override
    public Iterator<V> distributedIterator(String pattern) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, null, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonSetCache.this.distributedScanIterator(iteratorName, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, String pattern, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, pattern, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, String pattern, int count) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(System.currentTimeMillis());
        if (pattern != null) {
            args.add(pattern);
        }
        args.add(count);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SCAN, "local cursor = redis.call('get', KEYS[2]); if cursor ~= false then cursor = tonumber(cursor); else cursor = 0;end;if cursor == -1 then return {0, {}}; end;local result; if (#ARGV == 3) then result = redis.call('zscan', KEYS[1], cursor, 'match', ARGV[2], 'count', ARGV[3]); else result = redis.call('zscan', KEYS[1], cursor, 'count', ARGV[2]); end;local next_cursor = result[1]if next_cursor ~= \"0\" then redis.call('setex', KEYS[2], 3600, next_cursor);else redis.call('setex', KEYS[2], 3600, -1);end; local res = {};for i, value in ipairs(result[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[1]) then table.insert(res, result[2][i-1]); end; end; end;return {result[1], res};", Arrays.asList(this.getRawName(), iteratorName), args.toArray());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V removeRandom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public Set<V> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public boolean move(String destination, V member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public Integer countIntersection(String ... names) {
        return this.get(this.countIntersectionAsync(names));
    }

    @Override
    public Integer countIntersection(int limit, String ... names) {
        return this.get(this.countIntersectionAsync(limit, names));
    }

    @Override
    public Set<V> containsEach(Collection<V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> randomAsync() {
        String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", this.getRawName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_OBJECT, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2], 'WITHSCORES');for i = 1, #values, 2 do redis.call('zadd', KEYS[2], values[i], values[i+1]); end;local res = redis.call('zrandmember', KEYS[2]); redis.call('del', KEYS[2]); return res;", Arrays.asList(this.getRawName(), tempName), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public RFuture<Set<V>> randomAsync(int count) {
        String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", this.getRawName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2], 'WITHSCORES');for i = 1, #values, 2 do redis.call('zadd', KEYS[2], values[i], values[i+1]); end;local res = redis.call('zrandmember', KEYS[2], ARGV[3]); redis.call('del', KEYS[2]); return res;", Arrays.asList(this.getRawName(), tempName), System.currentTimeMillis(), 92233720368547758L, count);
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'AGGREGATE'); table.insert(args, 'SUM'); local res = redis.call('zunionstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "local args = {} table.insert(args, #KEYS) for _, key_name in ipairs(KEYS) do table.insert(args, key_name) end table.insert(args, 'WITHSCORES')local values = redis.call('zunion', unpack(args)) local res = {} for j = 1, #values, 2 do if tonumber(values[j+1]) > tonumber(ARGV[1]) then table.insert(res, values[j]);end end;return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; local res = redis.call('zdiffstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "local args = {} table.insert(args, #KEYS) for _, key_name in ipairs(KEYS) do table.insert(args, key_name) end table.insert(args, 'WITHSCORES')local values = redis.call('zdiff', unpack(args)) local res = {} for j = 1, #values, 2 do if tonumber(values[j+1]) > tonumber(ARGV[1]) then table.insert(res, values[j]);end end;return res;", keys, System.currentTimeMillis());
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'AGGREGATE'); table.insert(args, 'SUM'); local res = redis.call('zinterstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "local args = {} table.insert(args, #KEYS) for _, key_name in ipairs(KEYS) do table.insert(args, key_name) end table.insert(args, 'WITHSCORES')local values = redis.call('zinter', unpack(args)) local res = {} for j = 1, #values, 2 do if tonumber(values[j+1]) > tonumber(ARGV[1]) then table.insert(res, values[j]);end end;return res;", keys, System.currentTimeMillis());
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(String ... names) {
        return this.countIntersectionAsync(0, names);
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(int limit, String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(this.map(names));
        for (Object key : new ArrayList(keys)) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)IntegerCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {ARGV[3]};for i = 1, ARGV[3], 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = tonumber(ARGV[3]) + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'LIMIT'); table.insert(args, ARGV[4]); local res = redis.call('zintercard', unpack(args));redis.call('del', unpack(KEYS, ARGV[3]+1, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1, limit);
    }

    @Override
    public RFuture<Integer> addAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        for (V v : c) {
            args.add(92233720368547758L);
            try {
                args.add(v);
            }
            catch (Exception e) {
                args.forEach(vv -> ReferenceCountUtil.safeRelease(vv));
                throw e;
            }
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, args.toArray());
    }

    @Override
    public RFuture<Integer> removeAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM_INT, args.toArray());
    }

    @Override
    public RFuture<Set<V>> containsEachAsync(Collection<V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order) {
        return this.get(this.readSortAlphaAsync(order));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, order));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.readSortAsync(null, null, order, -1, -1, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.readSortAsync(null, null, order, offset, count, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.readSortAsync(byPattern, null, order, -1, -1, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, null, order, offset, count, false);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, false);
    }

    private <T> RFuture<T> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count, boolean alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.readSortAsync(null, null, order, -1, -1, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.readSortAsync(null, null, order, offset, count, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.readSortAsync(byPattern, null, order, -1, -1, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, null, order, offset, count, true);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1, true);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, true);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, null, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, null, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, null, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, null, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addIfAbsent(Duration ttl, V object) {
        return this.get(this.addIfAbsentAsync(ttl, object));
    }

    @Override
    public boolean addIfExists(Duration ttl, V object) {
        return this.get(this.addIfExistsAsync(ttl, object));
    }

    @Override
    public boolean addIfLess(Duration ttl, V object) {
        return this.get(this.addIfLessAsync(ttl, object));
    }

    @Override
    public boolean addIfGreater(Duration ttl, V object) {
        return this.get(this.addIfGreaterAsync(ttl, object));
    }

    @Override
    public RFuture<Boolean> addIfAbsentAsync(Duration ttl, V object) {
        long timeoutDate = System.currentTimeMillis() + ttl.toMillis();
        if (ttl.isZero()) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0; end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; ", Arrays.asList(this.getRawName()), System.currentTimeMillis(), timeoutDate, this.encode(object));
    }

    @Override
    public RFuture<Boolean> addIfExistsAsync(Duration ttl, V object) {
        long timeoutDate = System.currentTimeMillis() + ttl.toMillis();
        if (ttl.isZero()) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then if tonumber(expireDateScore) < tonumber(ARGV[1]) then return 0; end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; end; return 0; ", Arrays.asList(this.getRawName()), System.currentTimeMillis(), timeoutDate, this.encode(object));
    }

    @Override
    public RFuture<Boolean> addIfLessAsync(Duration ttl, V object) {
        long timeoutDate = System.currentTimeMillis() + ttl.toMillis();
        if (ttl.isZero()) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then if tonumber(expireDateScore) < tonumber(ARGV[1]) or tonumber(ARGV[2]) >= tonumber(expireDateScore) then return 0; end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; end; return 0; ", Arrays.asList(this.getRawName()), System.currentTimeMillis(), timeoutDate, this.encode(object));
    }

    @Override
    public RFuture<Boolean> addIfGreaterAsync(Duration ttl, V object) {
        long timeoutDate = System.currentTimeMillis() + ttl.toMillis();
        if (ttl.isZero()) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then if tonumber(expireDateScore) < tonumber(ARGV[1]) or tonumber(ARGV[2]) <= tonumber(expireDateScore) then return 0; end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; end; return 0; ", Arrays.asList(this.getRawName()), System.currentTimeMillis(), timeoutDate, this.encode(object));
    }

    @Override
    public int addAllIfAbsent(Map<V, Duration> objects) {
        return this.get(this.addAllIfAbsentAsync(objects));
    }

    @Override
    public boolean addIfAbsent(Map<V, Duration> objects) {
        return this.get(this.addIfAbsentAsync(objects));
    }

    @Override
    public int addAllIfExist(Map<V, Duration> objects) {
        return this.get(this.addAllIfExistAsync(objects));
    }

    @Override
    public int addAllIfGreater(Map<V, Duration> objects) {
        return this.get(this.addAllIfGreaterAsync(objects));
    }

    @Override
    public int addAllIfLess(Map<V, Duration> objects) {
        return this.get(this.addAllIfLessAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllIfAbsentAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local result = 0; for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if expireDateScore == false or tonumber(expireDateScore) <= tonumber(ARGV[1]) then result = result + 1; redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; end; return result; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Boolean> addIfAbsentAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0; end; end; for i=2, #ARGV, 2 do redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; return 1; ", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Integer> addAllIfExistAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local result = 0; for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then result = result + 1; redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; end; return result; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Integer> addAllIfGreaterAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local result = 0; for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) and tonumber(ARGV[i]) > tonumber(expireDateScore) then result = result + 1; redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; end; return result; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Integer> addAllIfLessAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local result = 0; for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) and tonumber(ARGV[i]) < tonumber(expireDateScore) then result = result + 1; redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; end; return result; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public int addAll(Map<V, Duration> objects) {
        return this.get(this.addAllAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllAsync(Map<V, Duration> objects) {
        ArrayList<Long> params = new ArrayList<Long>();
        long currentTime = System.currentTimeMillis();
        params.add(currentTime);
        for (Map.Entry<V, Duration> entry : objects.entrySet()) {
            long timeoutDate = currentTime + entry.getValue().toMillis();
            if (entry.getValue().isZero()) {
                timeoutDate = 92233720368547758L - currentTime;
            }
            params.add(timeoutDate);
            this.encode(params, entry.getKey());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local result = 0; for i=2, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[i+1]); if not (expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1])) then result = result + 1; end; redis.call('zadd', KEYS[1], ARGV[i], ARGV[i+1]); end; return result; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListener("__keyevent@*:zadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListener("__keyevent@*:zrem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListener((TrackingListener)listener);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListenerAsync("__keyevent@*:zadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListenerAsync("__keyevent@*:zrem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListenerAsync((TrackingListener)listener);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public AsyncIterator<V> iteratorAsync() {
        return this.iteratorAsync(10);
    }

    @Override
    public AsyncIterator<V> iteratorAsync(final int count) {
        BaseAsyncIterator asyncIterator = new BaseAsyncIterator<V, Object>(){

            @Override
            protected RFuture<ScanResult<Object>> iterator(RedisClient client, String nextItPos) {
                return RedissonSetCache.this.scanIteratorAsync(RedissonSetCache.this.name, client, nextItPos, null, count);
            }
        };
        return new CompositeAsyncIterator(Arrays.asList(asyncIterator), 0);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeTrackingListener(listenerId);
        this.removeListener(listenerId, "__keyevent@*:zadd", "__keyevent@*:zrem");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RFuture<Void> f1 = this.removeTrackingListenerAsync(listenerId);
        RFuture<Void> f2 = this.removeListenerAsync(listenerId, "__keyevent@*:zadd", "__keyevent@*:zrem");
        return new CompletableFutureWrapper<Void>(CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture()));
    }
}

