/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMultimap;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

class RedissonMultimapCacheNative<K> {
    private final CommandAsyncExecutor commandExecutor;
    private final RedissonMultimap<K, ?> object;
    private final String prefix;

    RedissonMultimapCacheNative(CommandAsyncExecutor commandExecutor, RObject object, String prefix) {
        this.commandExecutor = commandExecutor;
        this.object = (RedissonMultimap)object;
        this.prefix = prefix;
    }

    public RFuture<Boolean> expireKeyAsync(K key, long timeToLive, TimeUnit timeUnit) {
        ByteBuf keyState = this.object.encodeMapKey(key);
        String keyHash = this.object.hash(keyState);
        String setName = this.object.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.object.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2])if res[1] == 1 then redis.call('pexpire', KEYS[2], ARGV[1]); return 1;end; return 0; ", Arrays.asList(this.object.getRawName(), setName), timeUnit.toMillis(timeToLive), this.object.encodeMapKey(key));
    }

    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param) {
        return this.commandExecutor.evalWriteAsync(this.object.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; if ARGV[3] ~= '' then redis.call('pexpire', name, ARGV[1], ARGV[3]); else redis.call('pexpire', name, ARGV[1]); end; end;end; if ARGV[3] ~= '' then return redis.call('pexpire', KEYS[1], ARGV[1], ARGV[3]); end; return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.object.getRawName()), timeUnit.toMillis(timeToLive), this.prefix, param);
    }

    public RFuture<Boolean> expireAtAsync(long timestamp, String param) {
        return this.commandExecutor.evalWriteAsync(this.object.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; if ARGV[3] ~= '' then redis.call('pexpireat', name, ARGV[1], ARGV[3]); else redis.call('pexpireat', name, ARGV[1]); end; end;end; if ARGV[3] ~= '' then return redis.call('pexpireat', KEYS[1], ARGV[1], ARGV[3]); end; return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.object.getRawName()), timestamp, this.prefix, param);
    }

    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.object.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[1] .. v; redis.call('persist', name); end;end; return redis.call('persist', KEYS[1]); ", Arrays.asList(this.object.getRawName()), this.prefix);
    }
}

