/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.redisson.MapWriterTask;
import org.redisson.RedissonMap;
import org.redisson.WriteBehindService;
import org.redisson.api.MapOptions;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MapExpiredListener;
import org.redisson.api.map.PutArgs;
import org.redisson.api.map.PutParams;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapNativeAllDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonMapCacheNative<K, V>
extends RedissonMap<K, V>
implements RMapCacheNative<K, V> {
    public RedissonMapCacheNative(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(commandExecutor, name, redisson, options, writeBehindService);
    }

    public RedissonMapCacheNative(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    public RedissonMapCacheNative(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(codec, commandExecutor, name, redisson, options, writeBehindService);
    }

    @Override
    public V put(K key, V value, Duration ttl) {
        return this.get(this.putAsync(key, value, ttl));
    }

    @Override
    public V put(K key, V value, Instant time) {
        return this.get(this.putAsync(key, value, time));
    }

    @Override
    public RFuture<V> putAsync(K key, V value, Duration ttl) {
        return this.putAsyncInternal(key, value, ttl.toMillis(), true);
    }

    @Override
    public RFuture<V> putAsync(K key, V value, Instant time) {
        return this.putAsyncInternal(key, value, time.toEpochMilli(), false);
    }

    private RFuture<V> putAsyncInternal(K key, V value, long ms, boolean isDuration) {
        this.checkKey(key);
        this.checkValue(value);
        if (ms < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ms == 0L) {
            return this.putAsync(key, value);
        }
        RFuture<V> future = this.putOperationAsync(key, value, ms, isDuration);
        future = new CompletableFutureWrapper<V>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, listener);
    }

    protected RFuture<V> putOperationAsync(K key, V value, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call(ARGV[4], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return currValue; ", Collections.singletonList(name), ms, this.encodeMapKey(key), this.encodeMapValue(value), this.getExpireCommand(isDuration));
    }

    @Override
    public boolean fastPut(K key, V value, Duration ttl) {
        return this.get(this.fastPutAsync(key, value, ttl));
    }

    @Override
    public boolean fastPut(K key, V value, Instant time) {
        return this.get(this.fastPutAsync(key, value, time));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, Duration ttl) {
        return this.fastPutAsyncInternal(key, value, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, Instant time) {
        return this.fastPutAsyncInternal(key, value, time.toEpochMilli(), false);
    }

    private RFuture<Boolean> fastPutAsyncInternal(K key, V value, long ms, boolean isDuration) {
        this.checkKey(key);
        this.checkValue(value);
        if (ms < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ms == 0L) {
            return this.fastPutAsync(key, value);
        }
        RFuture<Boolean> future = this.fastPutOperationAsync(key, value, ms, isDuration);
        future = new CompletableFutureWrapper<Boolean>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local added = redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call(ARGV[4], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return added;", Collections.singletonList(name), ms, this.encodeMapKey(key), this.encodeMapValue(value), this.getExpireCommand(isDuration));
    }

    @Override
    public V putIfAbsent(K key, V value, Duration ttl) {
        return this.get(this.putIfAbsentAsync(key, value, ttl));
    }

    @Override
    public V putIfAbsent(K key, V value, Instant time) {
        return this.get(this.putIfAbsentAsync(key, value, time));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, Duration ttl) {
        return this.putIfAbsentAsyncInternal(key, value, ttl.toMillis(), true);
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, Instant time) {
        return this.putIfAbsentAsyncInternal(key, value, time.toEpochMilli(), false);
    }

    private RFuture<V> putIfAbsentAsyncInternal(K key, V value, long ms, boolean isDuration) {
        this.checkKey(key);
        this.checkValue(value);
        if (ms < 0L) {
            throw new IllegalArgumentException("ms can't be negative");
        }
        if (ms == 0L) {
            return this.putIfAbsentAsync(key, value);
        }
        RFuture<V> future = this.putIfAbsentOperationAsync(key, value, ms, isDuration);
        future = new CompletableFutureWrapper<V>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r == null);
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        if (value == null) {
            return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HGET, name, this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); if currValue ~= false then return currValue;end;redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call(ARGV[4], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return nil; ", Collections.singletonList(name), ms, this.encodeMapKey(key), this.encodeMapValue(value), this.getExpireCommand(isDuration));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value, Duration ttl) {
        return this.get(this.fastPutIfAbsentAsync(key, value, ttl));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value, Instant time) {
        return this.get(this.fastPutIfAbsentAsync(key, value, time));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, Duration ttl) {
        return this.fastPutIfAbsentAsyncInternal(key, value, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, Instant time) {
        return this.fastPutIfAbsentAsyncInternal(key, value, time.toEpochMilli(), false);
    }

    private RFuture<Boolean> fastPutIfAbsentAsyncInternal(K key, V value, long ms, boolean isDuration) {
        this.checkKey(key);
        this.checkValue(value);
        if (ms < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ms == 0L) {
            return this.fastPutIfAbsentAsync(key, value);
        }
        RFuture<Boolean> future = this.fastPutIfAbsentOperationAsync(key, value, ms, isDuration);
        future = new CompletableFutureWrapper<Boolean>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        if (value == null) {
            return this.commandExecutor.evalReadAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('hget', KEYS[1], ARGV[1]); if currValue ~= false then return 0;end;return 1; ", Collections.singletonList(name), this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); if currValue ~= false then return 0;end;redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call(ARGV[4], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return 1; ", Collections.singletonList(name), ms, this.encodeMapKey(key), this.encodeMapValue(value), this.getExpireCommand(isDuration));
    }

    @Override
    public long remainTimeToLive(K key) {
        return this.get(this.remainTimeToLiveAsync(key));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(K key) {
        this.checkKey(key);
        String name = this.getRawName(key);
        return this.commandExecutor.readAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.HPTTL, name, "FIELDS", 1, this.encodeMapKey(key));
    }

    @Override
    public Map<K, Long> remainTimeToLive(Set<K> keys) {
        return this.get(this.remainTimeToLiveAsync(keys));
    }

    @Override
    public RFuture<Map<K, Long>> remainTimeToLiveAsync(Set<K> keys) {
        ArrayList<Object> plainKeys = new ArrayList<Object>(keys);
        ArrayList<Object> params = new ArrayList<Object>(keys.size() + 1);
        params.add(this.getRawName());
        params.add("FIELDS");
        params.add(plainKeys.size());
        this.encodeMapKeys(params, plainKeys);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("HPTTL", new MapNativeAllDecoder(plainKeys, Long.class));
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    @Override
    public void putAll(PutArgs<K, V> args) {
        this.get(this.putAllAsync(args));
    }

    @Override
    public RFuture<Void> putAllAsync(PutArgs<K, V> args) {
        return this.putAllAsyncInternal(args);
    }

    private RFuture<Void> putAllAsyncInternal(PutArgs<K, V> args) {
        PutParams params = (PutParams)args;
        if (params.getEntries().isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<Void> future = this.putAllOperationAsync(params);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(params.getEntries());
        return this.mapWriterFuture(future, listener);
    }

    @Override
    protected RFuture<Void> putAllOperationAsync(PutParams<K, V> params) {
        ArrayList<Object> cmdParams = new ArrayList<Object>(params.getEntries().size() * 2 + 4);
        cmdParams.add(this.getRawName());
        if (params.isKeepTTL()) {
            cmdParams.add("KEEPTTL");
        } else if (params.getTimeToLive() != null) {
            cmdParams.add("PX");
            cmdParams.add(params.getTimeToLive().toMillis());
        } else if (params.getExpireAt() != null) {
            cmdParams.add("PXAT");
            cmdParams.add(params.getExpireAt().toEpochMilli());
        }
        cmdParams.add("FIELDS");
        cmdParams.add(params.getEntries().size());
        this.encodeMapKeys(cmdParams, params.getEntries());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.HSETEX_VOID, cmdParams.toArray());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Duration ttl) {
        this.get(this.putAllAsync(map, ttl));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Duration ttl) {
        return this.putAllAsyncInternal(map, ttl.toMillis());
    }

    private RFuture<Void> putAllAsyncInternal(Map<? extends K, ? extends V> map, long ms) {
        if (map.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<Void> future = this.putAllOperationAsync(map, ms);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(map);
        return this.mapWriterFuture(future, listener);
    }

    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map, long ms) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(ms);
        this.encodeMapKeys(args, map);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "for i = 2, #ARGV, 2 do redis.call('hset', KEYS[1], ARGV[i], ARGV[i + 1]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[i]); end; ", Collections.singletonList(this.name), args.toArray());
    }

    @Override
    public boolean expireEntry(K key, Duration ttl) {
        return this.get(this.expireEntryAsync(key, ttl));
    }

    @Override
    public boolean expireEntry(K key, Instant time) {
        return this.get(this.expireEntryAsync(key, time));
    }

    @Override
    public RFuture<Boolean> expireEntryAsync(K key, Duration ttl) {
        return this.expireEntryAsyncInternal(key, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> expireEntryAsync(K key, Instant time) {
        return this.expireEntryAsyncInternal(key, time.toEpochMilli(), false);
    }

    private RFuture<Boolean> expireEntryAsyncInternal(K key, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expireSet = redis.call(ARGV[3], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); if #expireSet > 0 and expireSet[1] >= 1 then return 1;end; return 0; ", Arrays.asList(name), ms, this.encodeMapKey(key), this.getExpireCommand(isDuration));
    }

    @Override
    public boolean expireEntryIfNotSet(K key, Duration ttl) {
        return this.get(this.expireEntryIfNotSetAsync(key, ttl));
    }

    @Override
    public boolean expireEntryIfNotSet(K key, Instant time) {
        return this.get(this.expireEntryIfNotSetAsync(key, time));
    }

    @Override
    public RFuture<Boolean> expireEntryIfNotSetAsync(K key, Duration ttl) {
        return this.expireEntryAsync("NX", key, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> expireEntryIfNotSetAsync(K key, Instant time) {
        return this.expireEntryAsync("NX", key, time.toEpochMilli(), false);
    }

    private RFuture<Boolean> expireEntryAsync(String param, K key, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expireSet = redis.call(ARGV[4], KEYS[1], ARGV[1], ARGV[3], 'fields', 1, ARGV[2]); if #expireSet > 0 and expireSet[1] >= 1 then return 1;end; return 0; ", Arrays.asList(name), ms, this.encodeMapKey(key), param, this.getExpireCommand(isDuration));
    }

    @Override
    public int expireEntries(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesAsync(keys, ttl));
    }

    @Override
    public int expireEntries(Set<K> keys, Instant time) {
        return this.get(this.expireEntriesAsync(keys, time));
    }

    @Override
    public RFuture<Integer> expireEntriesAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsyncInternal(keys, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Integer> expireEntriesAsync(Set<K> keys, Instant time) {
        return this.expireEntriesAsyncInternal(keys, time.toEpochMilli(), false);
    }

    private RFuture<Integer> expireEntriesAsyncInternal(Set<K> keys, long ms, boolean isDuration) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(ms);
        args.add(this.getExpireCommand(isDuration));
        this.encodeMapKeys(args, keys);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local result = 0;for j = 3, #ARGV, 1 do local expireSet = redis.call(ARGV[2], KEYS[1], ARGV[1], 'fields', 1, ARGV[j]); if #expireSet > 0 and expireSet[1] >= 1 then result = result + 1;end; end; return result; ", Arrays.asList(this.name), args.toArray());
    }

    @Override
    public int expireEntriesIfNotSet(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfNotSetAsync(keys, ttl));
    }

    @Override
    public int expireEntriesIfNotSet(Set<K> keys, Instant time) {
        return this.get(this.expireEntriesIfNotSetAsync(keys, time));
    }

    @Override
    public RFuture<Integer> expireEntriesIfNotSetAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsyncInternal("NX", keys, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Integer> expireEntriesIfNotSetAsync(Set<K> keys, Instant time) {
        return this.expireEntriesAsyncInternal("NX", keys, time.toEpochMilli(), false);
    }

    private RFuture<Integer> expireEntriesAsyncInternal(String param, Set<K> keys, long ms, boolean isDuration) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(param);
        args.add(ms);
        args.add(this.getExpireCommand(isDuration));
        this.encodeMapKeys(args, keys);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local result = 0;for j = 4, #ARGV, 1 do local expireSet = redis.call(ARGV[3], KEYS[1], ARGV[2], ARGV[1], 'fields', 1, ARGV[j]); if #expireSet > 0 and expireSet[1] >= 1 then result = result + 1;end; end; return result; ", Arrays.asList(this.name), args.toArray());
    }

    @Override
    public boolean expireEntryIfGreater(K key, Duration ttl) {
        return this.get(this.expireEntryIfGreaterAsync(key, ttl));
    }

    @Override
    public boolean expireEntryIfGreater(K key, Instant time) {
        return this.get(this.expireEntryIfGreaterAsync(key, time));
    }

    @Override
    public boolean expireEntryIfLess(K key, Duration ttl) {
        return this.get(this.expireEntryIfLessAsync(key, ttl));
    }

    @Override
    public boolean expireEntryIfLess(K key, Instant time) {
        return this.get(this.expireEntryIfLessAsync(key, time));
    }

    @Override
    public int expireEntriesIfGreater(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfGreaterAsync(keys, ttl));
    }

    @Override
    public int expireEntriesIfGreater(Set<K> keys, Instant time) {
        return this.get(this.expireEntriesIfGreaterAsync(keys, time));
    }

    @Override
    public int expireEntriesIfLess(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfLessAsync(keys, ttl));
    }

    @Override
    public int expireEntriesIfLess(Set<K> keys, Instant time) {
        return this.get(this.expireEntriesIfLessAsync(keys, time));
    }

    @Override
    public RFuture<Boolean> expireEntryIfGreaterAsync(K key, Duration ttl) {
        return this.expireEntryAsync("GT", key, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> expireEntryIfGreaterAsync(K key, Instant time) {
        return this.expireEntryAsync("GT", key, time.toEpochMilli(), false);
    }

    @Override
    public RFuture<Boolean> expireEntryIfLessAsync(K key, Duration ttl) {
        return this.expireEntryAsync("LT", key, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Boolean> expireEntryIfLessAsync(K key, Instant time) {
        return this.expireEntryAsync("LT", key, time.toEpochMilli(), false);
    }

    @Override
    public RFuture<Integer> expireEntriesIfGreaterAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsyncInternal("GT", keys, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Integer> expireEntriesIfGreaterAsync(Set<K> keys, Instant time) {
        return this.expireEntriesAsyncInternal("GT", keys, time.toEpochMilli(), false);
    }

    @Override
    public RFuture<Integer> expireEntriesIfLessAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsyncInternal("LT", keys, ttl.toMillis(), true);
    }

    @Override
    public RFuture<Integer> expireEntriesIfLessAsync(Set<K> keys, Instant time) {
        return this.expireEntriesAsyncInternal("LT", keys, time.toEpochMilli(), false);
    }

    @Override
    public Boolean clearExpire(K key) {
        return this.get(this.clearExpireAsync(key));
    }

    @Override
    public RFuture<Boolean> clearExpireAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.writeAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.HPERSIST, name, "FIELDS", 1, this.encodeMapKey(key));
    }

    @Override
    public Map<K, Boolean> clearExpire(Set<K> keys) {
        return this.get(this.clearExpireAsync(keys));
    }

    @Override
    public RFuture<Map<K, Boolean>> clearExpireAsync(Set<K> keys) {
        ArrayList<Object> plainKeys = new ArrayList<Object>(keys);
        ArrayList<Object> params = new ArrayList<Object>(keys.size() + 1);
        params.add(this.getRawName());
        params.add("FIELDS");
        params.add(plainKeys.size());
        this.encodeMapKeys(params, plainKeys);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("HPERSIST", new MapNativeAllDecoder(plainKeys, Boolean.class));
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof MapExpiredListener) {
            return this.addListener("__keyevent@*:hexpired", (MapExpiredListener)listener, MapExpiredListener::onExpired);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof MapExpiredListener) {
            return this.addListenerAsync("__keyevent@*:hexpired", (MapExpiredListener)listener, MapExpiredListener::onExpired);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:hexpired");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(super.removeListenerAsync(listenerId), listenerId, "__keyevent@*:hexpired");
    }

    @Override
    public V compute(K key, Duration ttl, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeInternal(key, ttl.toMillis(), true, remappingFunction);
    }

    @Override
    public V compute(K key, Instant time, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeInternal(key, time.toEpochMilli(), false, remappingFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V computeInternal(K key, long ms, boolean isDuration, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkNotBatch();
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            Object oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (oldValue != null) {
                    this.fastRemove(key);
                }
            } else {
                this.get(this.fastPutAsyncInternal(key, newValue, ms, isDuration));
            }
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeAsync(K key, Duration ttl, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsyncInternal(key, ttl.toMillis(), true, remappingFunction);
    }

    @Override
    public RFuture<V> computeAsync(K key, Instant time, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsyncInternal(key, time.toEpochMilli(), false, remappingFunction);
    }

    private RFuture<V> computeAsyncInternal(K key, long ms, boolean isDuration, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkNotBatch();
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture oldValueFuture = this.getAsync(key, threadId);
            return oldValueFuture.thenCompose(oldValue -> CompletableFuture.supplyAsync(() -> remappingFunction.apply((Object)key, (Object)oldValue), this.getServiceManager().getExecutor()).thenCompose(newValue -> {
                if (newValue == null) {
                    if (oldValue != null) {
                        return this.fastRemoveAsync(key).thenApply(rr -> newValue);
                    }
                    return CompletableFuture.completedFuture(newValue);
                }
                return this.fastPutAsyncInternal(key, newValue, ms, isDuration).thenApply(rr -> newValue);
            })).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    @Override
    public V computeIfAbsent(K key, Duration ttl, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentInternal(key, ttl.toMillis(), true, mappingFunction);
    }

    @Override
    public V computeIfAbsent(K key, Instant time, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentInternal(key, time.toEpochMilli(), false, mappingFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V computeIfAbsentInternal(K key, long ms, boolean isDuration, Function<? super K, ? extends V> mappingFunction) {
        this.checkNotBatch();
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        if (value != null) {
            return value;
        }
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            value = this.get(key);
            if (value == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    V r = this.get(this.putIfAbsentAsyncInternal(key, newValue, ms, isDuration));
                    if (r != null) {
                        V v = r;
                        return v;
                    }
                    V v = newValue;
                    return v;
                }
                V v = null;
                return v;
            }
            Object v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeIfAbsentAsync(K key, Duration ttl, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsyncInternal(key, ttl.toMillis(), true, mappingFunction);
    }

    @Override
    public RFuture<V> computeIfAbsentAsync(K key, Instant time, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsyncInternal(key, time.toEpochMilli(), false, mappingFunction);
    }

    public RFuture<V> computeIfAbsentAsyncInternal(K key, long ms, boolean isDuration, Function<? super K, ? extends V> mappingFunction) {
        this.checkNotBatch();
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture oldValueFuture = this.getAsync(key, threadId);
            return oldValueFuture.thenCompose(oldValue -> {
                if (oldValue != null) {
                    return CompletableFuture.completedFuture(oldValue);
                }
                return CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), this.getServiceManager().getExecutor()).thenCompose(newValue -> {
                    if (newValue != null) {
                        return this.putIfAbsentAsyncInternal(key, newValue, ms, isDuration).thenApply(rr -> {
                            if (rr != null) {
                                return rr;
                            }
                            return newValue;
                        });
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    private String getExpireCommand(boolean isDuration) {
        if (isDuration) {
            return "hpexpire";
        }
        return "hpexpireat";
    }

    @Override
    public V putIfExist(K key, V value, Duration ttl) {
        return this.get(this.putIfExistAsync(key, value, ttl));
    }

    @Override
    public V putIfExist(K key, V value, Instant time) {
        return this.get(this.putIfExistAsync(key, value, time));
    }

    @Override
    public RFuture<V> putIfExistAsync(K key, V value, Duration ttl) {
        return this.putIfExistAsyncInternal(key, value, ttl.toMillis(), true);
    }

    @Override
    public RFuture<V> putIfExistAsync(K key, V value, Instant time) {
        return this.putIfExistAsyncInternal(key, value, time.toEpochMilli(), false);
    }

    private RFuture<V> putIfExistAsyncInternal(K key, V value, long ms, boolean isDuration) {
        this.checkKey(key);
        if (ms < 0L) {
            throw new IllegalArgumentException("ms can't be negative");
        }
        if (ms == 0L) {
            return this.putIfExistsAsync(key, value);
        }
        RFuture<V> future = this.putIfExistOperationAsync(key, value, ms, isDuration);
        future = new CompletableFutureWrapper<V>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r != null);
    }

    protected RFuture<V> putIfExistOperationAsync(K key, V value, long ms, boolean isDuration) {
        String name = this.getRawName(key);
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local currValue = redis.call('hget', KEYS[1], ARGV[1]); if currValue == false then return nil;end;redis.call('hdel', KEYS[1], ARGV[1]); return currValue; ", Collections.singletonList(name), this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); if currValue == false then return nil;end;redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call(ARGV[4], KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return currValue; ", Collections.singletonList(name), ms, this.encodeMapKey(key), this.encodeMapValue(value), this.getExpireCommand(isDuration));
    }

    @Override
    public boolean putIfAllKeysExist(PutArgs<K, V> args) {
        return this.get(this.putIfAllKeysExistAsync(args));
    }

    @Override
    public RFuture<Boolean> putIfAllKeysExistAsync(PutArgs<K, V> args) {
        return this.putAllKeysAsync((PutParams)args, "FXX");
    }

    protected RFuture<Boolean> putAllKeysAsync(PutParams<K, V> params, String condition) {
        if (params.getEntries().isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = this.putAllKeysOperationAsync(params, condition);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(params.getEntries());
        return this.mapWriterFuture(future, listener, n -> n);
    }

    protected RFuture<Boolean> putAllKeysOperationAsync(PutParams<K, V> params, String condition) {
        Map<K, V> map = params.getEntries();
        if (map.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> cmdParams = new ArrayList<Object>(map.size() * 2 + 6);
        cmdParams.add(this.getRawName());
        cmdParams.add(condition);
        if (params.isKeepTTL()) {
            cmdParams.add("KEEPTTL");
        } else if (params.getTimeToLive() != null) {
            cmdParams.add("PX");
            cmdParams.add(params.getTimeToLive().toMillis());
        } else if (params.getExpireAt() != null) {
            cmdParams.add("PXAT");
            cmdParams.add(params.getExpireAt().toEpochMilli());
        }
        cmdParams.add("FIELDS");
        cmdParams.add(map.size());
        this.encodeMapKeys(cmdParams, params.getEntries());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.HSETEX, cmdParams.toArray());
    }

    @Override
    public boolean putIfAllKeysAbsent(PutArgs<K, V> args) {
        return this.get(this.putIfAllKeysAbsentAsync(args));
    }

    @Override
    public RFuture<Boolean> putIfAllKeysAbsentAsync(PutArgs<K, V> args) {
        return this.putAllKeysAsync((PutParams)args, "FNX");
    }
}

