/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBuckets;
import org.redisson.api.RBuckets;
import org.redisson.api.bucket.SetArgs;
import org.redisson.api.bucket.SetParams;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public abstract class BucketsSetOperation
extends TransactionalOperation {
    private final String transactionId;
    private final SetArgs setArgs;

    public BucketsSetOperation(Codec codec, SetArgs setArgs, String transactionId) {
        super(null, codec);
        this.setArgs = setArgs;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBuckets buckets = new RedissonBuckets(this.codec, commandExecutor);
        this.commit(buckets, this.setArgs);
        this.unlock(commandExecutor);
    }

    protected void unlock(CommandAsyncExecutor commandExecutor) {
        SetParams pps = (SetParams)this.setArgs;
        for (String key : pps.getEntries().keySet()) {
            RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.getLockName(key), this.transactionId);
            lock.unlockAsync();
        }
    }

    protected abstract void commit(RBuckets var1, SetArgs var2);

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        this.unlock(commandExecutor);
    }

    public SetArgs getSetArgs() {
        return this.setArgs;
    }

    private String getLockName(String name) {
        return name + ":transaction_lock";
    }
}

