/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.renewal.FastMultilockTask;
import org.redisson.renewal.LockTask;
import org.redisson.renewal.ReadLockTask;

public final class LockRenewalScheduler {
    private final AtomicReference<LockTask> reference = new AtomicReference();
    private final AtomicReference<FastMultilockTask> multilockReference = new AtomicReference();
    private final AtomicReference<ReadLockTask> readLockReference = new AtomicReference();
    private final CommandAsyncExecutor executor;
    private final int batchSize;
    private final long internalLockLeaseTime;

    public LockRenewalScheduler(CommandAsyncExecutor executor) {
        this.executor = executor;
        this.internalLockLeaseTime = executor.getServiceManager().getCfg().getLockWatchdogTimeout();
        this.batchSize = executor.getServiceManager().getCfg().getLockWatchdogBatchSize();
    }

    public void renewReadLock(String name, Long threadId, String lockName, String keyPrefix) {
        this.readLockReference.compareAndSet(null, new ReadLockTask(this.internalLockLeaseTime, this.executor, this.batchSize));
        ReadLockTask task = this.readLockReference.get();
        task.add(name, lockName, (long)threadId, keyPrefix);
    }

    public void renewFastMultiLock(String name, Long threadId, String lockName, Collection<String> fields) {
        this.multilockReference.compareAndSet(null, new FastMultilockTask(this.internalLockLeaseTime, this.executor));
        FastMultilockTask task = this.multilockReference.get();
        task.add(name, lockName, (long)threadId, fields);
    }

    public void renewLock(String name, Long threadId, String lockName) {
        this.reference.compareAndSet(null, new LockTask(this.internalLockLeaseTime, this.executor, this.batchSize));
        LockTask task = this.reference.get();
        task.add(name, lockName, threadId);
    }

    public void cancelReadLockRenewal(String name, Long threadId) {
        ReadLockTask rtask = this.readLockReference.get();
        if (rtask != null) {
            rtask.cancelExpirationRenewal(name, threadId);
        }
    }

    public void cancelFastMultilockRenewl(String name, Long threadId) {
        FastMultilockTask mtask = this.multilockReference.get();
        if (mtask != null) {
            mtask.cancelExpirationRenewal(name, threadId);
        }
    }

    public void cancelLockRenewal(String name, Long threadId) {
        LockTask task = this.reference.get();
        if (task != null) {
            task.cancelExpirationRenewal(name, threadId);
        }
    }
}

