/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.Map;
import org.redisson.config.NatMapper;
import org.redisson.misc.RedisURI;

public class HostPortNatMapper
implements NatMapper {
    private Map<String, String> hostsPortMap;

    @Override
    public RedisURI map(RedisURI uri) {
        String hostPort = this.hostsPortMap.get(uri.getHost() + ":" + uri.getPort());
        if (hostPort == null) {
            return uri;
        }
        int lastColonIdx = hostPort.lastIndexOf(":");
        String host = hostPort.substring(0, lastColonIdx);
        String port = hostPort.substring(lastColonIdx + 1);
        return new RedisURI(uri.getScheme(), host, Integer.valueOf(port));
    }

    public void setHostsPortMap(Map<String, String> hostsPortMap) {
        this.hostsPortMap = hostsPortMap;
    }
}

