/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.redisson.misc.Hash;

public final class CacheKeyParams {
    private final Object[] values;

    public CacheKeyParams(Object[] values) {
        this.values = Arrays.stream(values).map(value -> this.deepConvertByteBuf(value)).toArray();
    }

    private Object deepConvertByteBuf(Object obj) {
        if (obj instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)obj;
            return Hash.hash128(buf);
        }
        if (obj instanceof Object[]) {
            return Arrays.stream((Object[])obj).map(value -> this.deepConvertByteBuf(value)).toArray();
        }
        return obj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKeyParams cacheKey = (CacheKeyParams)o;
        return Arrays.deepEquals(this.values, cacheKey.values);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.values);
    }
}

