/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.bucket;

import java.time.Duration;
import java.time.Instant;
import org.redisson.api.bucket.CompareAndSetArgs;
import org.redisson.api.bucket.CompareAndSetStep;
import org.redisson.api.bucket.ConditionType;

public final class CompareAndSetParams<V>
implements CompareAndSetStep<V>,
CompareAndSetArgs<V> {
    private final ConditionType conditionType;
    private V expectedValue;
    private V unexpectedValue;
    private String expectedDigest;
    private String unexpectedDigest;
    private V newValue;
    private Duration timeToLive;
    private Instant expireAt;

    CompareAndSetParams(ConditionType conditionType, V object) {
        this.conditionType = conditionType;
        if (conditionType == ConditionType.EXPECTED) {
            this.expectedValue = object;
        }
        if (conditionType == ConditionType.UNEXPECTED) {
            this.unexpectedValue = object;
        }
    }

    CompareAndSetParams(ConditionType conditionType, String digest) {
        this.conditionType = conditionType;
        if (conditionType == ConditionType.EXPECTED_DIGEST) {
            this.expectedDigest = digest;
        }
        if (conditionType == ConditionType.UNEXPECTED_DIGEST) {
            this.unexpectedDigest = digest;
        }
    }

    @Override
    public CompareAndSetArgs<V> set(V value) {
        this.newValue = value;
        return this;
    }

    @Override
    public CompareAndSetArgs<V> timeToLive(Duration duration) {
        this.timeToLive = duration;
        return this;
    }

    @Override
    public CompareAndSetArgs<V> expireAt(Instant time) {
        this.expireAt = time;
        return this;
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    public V getExpectedValue() {
        return this.expectedValue;
    }

    public V getUnexpectedValue() {
        return this.unexpectedValue;
    }

    public String getExpectedDigest() {
        return this.expectedDigest;
    }

    public String getUnexpectedDigest() {
        return this.unexpectedDigest;
    }

    public V getNewValue() {
        return this.newValue;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }
}

