/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.renewal.LockRenewalScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseLock
extends RedissonExpirable
implements RLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseLock.class);
    final String id = this.getServiceManager().getId();
    final String entryName;
    final LockRenewalScheduler renewalScheduler;
    private static final RedisCommand<Integer> HGET = new RedisCommand<Integer>("HGET", new MapValueDecoder(), new IntegerReplayConvertor(0));

    public RedissonBaseLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.entryName = this.id + ":" + name;
        this.renewalScheduler = this.getServiceManager().getRenewalScheduler();
    }

    protected String getEntryName() {
        return this.entryName;
    }

    protected String getLockName(long threadId) {
        return this.id + ":" + threadId;
    }

    protected void scheduleExpirationRenewal(long threadId) {
        this.renewalScheduler.renewLock(this.getRawName(), threadId, this.getLockName(threadId));
    }

    protected void cancelExpirationRenewal(Long threadId, Boolean unlockResult) {
        this.renewalScheduler.cancelLockRenewal(this.getRawName(), threadId);
    }

    protected final <T> RFuture<T> evalWriteSyncedNoRetryAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.commandExecutor.syncedEvalNoRetry(key, codec, evalCommandType, script, keys, params);
    }

    protected void acquireFailed(long waitTime, TimeUnit unit, long threadId) {
        this.commandExecutor.get(this.acquireFailedAsync(waitTime, unit, threadId));
    }

    protected void trySuccessFalse(long currentThreadId, CompletableFuture<Boolean> result) {
        this.acquireFailedAsync(-1L, null, currentThreadId).whenComplete((res, e) -> {
            if (e == null) {
                result.complete(false);
            } else {
                result.completeExceptionally((Throwable)e);
            }
        });
    }

    protected CompletableFuture<Void> acquireFailedAsync(long waitTime, TimeUnit unit, long threadId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        return this.isExists();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        return this.isExistsAsync();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.isHeldByThread(Thread.currentThread().getId());
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        return this.get(this.isHeldByThreadAsync(threadId));
    }

    @Override
    public RFuture<Boolean> isHeldByThreadAsync(long threadId) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getRawName(), this.getLockName(threadId));
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, HGET, this.getRawName(), this.getLockName(Thread.currentThread().getId()));
    }

    @Override
    public int getHoldCount() {
        return this.get(this.getHoldCountAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        long threadId = Thread.currentThread().getId();
        return this.unlockAsync(threadId);
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        String requestId = this.getServiceManager().generateId();
        return this.getServiceManager().execute(() -> this.unlockAsync0(threadId, requestId));
    }

    private RFuture<Void> unlockAsync0(long threadId, String requestId) {
        RFuture<Boolean> future = this.unlockInnerAsync(threadId, requestId);
        CompletionStage<Void> f = future.handle((res, e) -> {
            this.cancelExpirationRenewal(threadId, (Boolean)res);
            if (e != null) {
                if (e instanceof CompletionException) {
                    throw (CompletionException)e;
                }
                throw new CompletionException((Throwable)e);
            }
            if (res == null) {
                IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + threadId);
                throw new CompletionException(cause);
            }
            return null;
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void unlock() {
        try {
            this.get(this.unlockAsync(Thread.currentThread().getId()));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IllegalMonitorStateException) {
                throw (IllegalMonitorStateException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    String getUnlockLatchName(String requestId) {
        return RedissonBaseLock.prefixName("redisson_unlock_latch", this.getRawName()) + ":" + requestId;
    }

    protected abstract RFuture<Boolean> unlockInnerAsync(long var1, String var3, int var4);

    protected final RFuture<Boolean> unlockInnerAsync(long threadId, String requestId) {
        if (requestId == null) {
            requestId = this.getServiceManager().generateId();
        }
        MasterSlaveServersConfig config = this.getServiceManager().getConfig();
        long timeout = ((long)config.getTimeout() + config.getRetryDelay().calcDelay(config.getRetryAttempts()).toMillis()) * (long)config.getRetryAttempts();
        timeout = Math.max(timeout, 1L);
        RFuture<Boolean> r = this.unlockInnerAsync(threadId, requestId, (int)timeout);
        CompletionStage<Boolean> ff = r.thenApply(v -> {
            CommandAsyncExecutor ce = this.commandExecutor;
            if (ce instanceof CommandBatchService) {
                ce = new CommandBatchService(this.commandExecutor);
            }
            ce.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.DEL, this.getUnlockLatchName(this.id));
            if (ce instanceof CommandBatchService) {
                ((CommandBatchService)ce).executeAsync();
            }
            return v;
        });
        return new CompletableFutureWrapper<Boolean>(ff);
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    protected final <T> CompletionStage<T> handleNoSync(long threadId, CompletionStage<T> ttlRemainingFuture) {
        return this.commandExecutor.handleNoSync(ttlRemainingFuture, (Throwable e) -> this.unlockInnerAsync(threadId, null));
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        throw new UnsupportedOperationException();
    }
}

