/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.protocol.pubsub.PubSubType;

public class PubSubStatusListener
implements RedisPubSubListener<Object> {
    private final StatusListener listener;
    private final String[] names;
    private final Set<String> notified = Collections.newSetFromMap(new ConcurrentHashMap());

    public PubSubStatusListener(StatusListener listener, String ... names) {
        this.listener = listener;
        this.names = names;
        this.notified.addAll(Arrays.asList(names));
    }

    @Override
    public void onMessage(CharSequence channel, Object message) {
    }

    @Override
    public void onPatternMessage(CharSequence pattern, CharSequence channel, Object message) {
    }

    @Override
    public void onStatus(PubSubType type, CharSequence channel) {
        this.notified.remove(channel.toString());
        if (this.notified.isEmpty()) {
            if (type == PubSubType.SUBSCRIBE || type == PubSubType.SSUBSCRIBE || type == PubSubType.PSUBSCRIBE) {
                this.listener.onSubscribe(channel.toString());
                this.notified.addAll(Arrays.asList(this.names));
            } else if (type == PubSubType.UNSUBSCRIBE || type == PubSubType.SUNSUBSCRIBE || type == PubSubType.PUNSUBSCRIBE) {
                this.listener.onUnsubscribe(channel.toString());
            }
        }
    }

    public String[] getNames() {
        return this.names;
    }

    public StatusListener getListener() {
        return this.listener;
    }
}

