/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanUtilBean;
import jodd.bean.BeanVisitor;
import org.redisson.spring.cache.CacheConfig;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class CacheConfigSupport {
    private final Yaml yamlParser;
    private final Yaml jsonParser;

    public CacheConfigSupport() {
        LoaderOptions yamlLoaderOptions = new LoaderOptions();
        yamlLoaderOptions.setTagInspector(tag -> true);
        DumperOptions yamlDumperOptions = new DumperOptions();
        yamlDumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        yamlDumperOptions.setPrettyFlow(true);
        yamlDumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        yamlDumperOptions.setIndent(2);
        CustomConstructor yamlConstructor = new CustomConstructor(yamlLoaderOptions);
        this.yamlParser = new Yaml((BaseConstructor)yamlConstructor, new Representer(yamlDumperOptions), yamlDumperOptions, yamlLoaderOptions);
        DumperOptions jsonDumperOptions = new DumperOptions();
        jsonDumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        jsonDumperOptions.setPrettyFlow(false);
        jsonDumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        Representer representer = new Representer(jsonDumperOptions);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        this.jsonParser = new Yaml(representer, jsonDumperOptions);
    }

    public Map<String, CacheConfig> fromJSON(String content) throws IOException {
        Map m = this.jsonParser.loadAs(content, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public Map<String, CacheConfig> fromJSON(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Map m = this.jsonParser.loadAs(reader, Map.class);
            Map<String, CacheConfig> map = CacheConfigSupport.fromMap(m, CacheConfig.class);
            return map;
        }
    }

    public Map<String, CacheConfig> fromJSON(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Map m = this.jsonParser.loadAs(is, Map.class);
            Map<String, CacheConfig> map = CacheConfigSupport.fromMap(m, CacheConfig.class);
            return map;
        }
    }

    public Map<String, CacheConfig> fromJSON(Reader reader) throws IOException {
        Map m = this.jsonParser.loadAs(reader, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public Map<String, CacheConfig> fromJSON(InputStream inputStream) throws IOException {
        Map m = this.jsonParser.loadAs(inputStream, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public String toJSON(Map<String, ? extends CacheConfig> configs) throws IOException {
        Map<String, Map<String, String>> plainMap = this.toPlainMap(configs);
        String value = this.jsonParser.dump(plainMap);
        return this.formatJson(value);
    }

    public Map<String, CacheConfig> fromYAML(String content) throws IOException {
        Map m = this.yamlParser.loadAs(content, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public static <T> Map<String, T> fromMap(Map<String, Map<String, Object>> configMap, Class<T> clazz) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, Map<String, Object>> entry : configMap.entrySet()) {
            String configName = entry.getKey();
            Map<String, Object> properties = entry.getValue();
            try {
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtilBean beanUtil = new BeanUtilBean();
                new BeanVisitor(properties).visit((name, value) -> {
                    if (!beanUtil.hasProperty(instance, name = name.replace("ttl", "TTL"))) {
                        throw new IllegalStateException("Field can't be found: " + name);
                    }
                    if ("listeners".equals(name)) {
                        List listValue = (List)value;
                        ArrayList<Object> listeners = new ArrayList<Object>();
                        for (Object val : listValue) {
                            if (!(val instanceof Map)) continue;
                            Object className = ((Map)val).get("class");
                            value = CacheConfigSupport.createListener(className.toString());
                            listeners.add(value);
                        }
                        if (!listeners.isEmpty()) {
                            value = listeners;
                        }
                    }
                    beanUtil.setProperty(instance, (String)name, value);
                });
                result.put(configName, instance);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to create instance of " + clazz.getName() + ": no-arg constructor required", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create instance of " + clazz.getName() + " for key: " + configName, e);
            }
        }
        return result;
    }

    public static Object createListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class not found: " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No no-arg constructor found for class: " + className, e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate class: " + className, e);
        }
    }

    public Map<String, CacheConfig> fromYAML(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Map m = this.yamlParser.loadAs(reader, Map.class);
            Map<String, CacheConfig> map = CacheConfigSupport.fromMap(m, CacheConfig.class);
            return map;
        }
    }

    public Map<String, CacheConfig> fromYAML(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Map m = this.yamlParser.loadAs(is, Map.class);
            Map<String, CacheConfig> map = CacheConfigSupport.fromMap(m, CacheConfig.class);
            return map;
        }
    }

    public Map<String, CacheConfig> fromYAML(Reader reader) throws IOException {
        Map m = this.yamlParser.loadAs(reader, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public Map<String, CacheConfig> fromYAML(InputStream inputStream) throws IOException {
        Map m = this.yamlParser.loadAs(inputStream, Map.class);
        return CacheConfigSupport.fromMap(m, CacheConfig.class);
    }

    public String toYAML(Map<String, ? extends CacheConfig> configs) throws IOException {
        Map<String, Map<String, String>> plainMap = this.toPlainMap(configs);
        return this.yamlParser.dump(plainMap);
    }

    private Map<String, Map<String, String>> toPlainMap(Map<String, ? extends CacheConfig> configs) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, ? extends CacheConfig> entry : configs.entrySet()) {
            String key = entry.getKey();
            CacheConfig config = entry.getValue();
            LinkedHashMap properties = new LinkedHashMap();
            BeanUtilBean beanUtil = new BeanUtilBean();
            new BeanVisitor(config).visit((name, value) -> {
                if ("listeners".equals(name)) {
                    return;
                }
                name = name.replace("TTL", "ttl");
                if (value instanceof Enum) {
                    value = value.toString();
                }
                beanUtil.setProperty(properties, (String)name, value);
            });
            result.put(key, properties);
        }
        return result;
    }

    private String formatJson(String json) {
        json = json.trim();
        json = json.replaceAll("!!int\\s+", "");
        json = json.replaceAll("!!long\\s+", "");
        json = json.replaceAll("!!float\\s+", "");
        json = json.replaceAll("!!double\\s+", "");
        json = json.replaceAll("!!bool\\s+", "");
        json = json.replaceAll("\\s*\\n\\s*", " ");
        json = json.replaceAll(":\\s*([^\\s])", ": $1");
        json = json.replaceAll(",\\s*([^\\s])", ", $1");
        json = json.replaceAll("\\{\\s+", "{");
        json = json.replaceAll("\\s+\\}", "}");
        json = json.replaceAll("\"(\\d+)\"", "$1");
        return json;
    }

    private static class CustomConstructor
    extends Constructor {
        CustomConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
        }

        @Override
        protected Class<?> getClassForNode(Node node) {
            String className = this.extractClassNameFromTag(node.getTag());
            if (className != null) {
                try {
                    return this.getClassForName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class not found: " + className, e);
                }
            }
            return super.getClassForNode(node);
        }

        private String extractClassNameFromTag(Tag tag) {
            String className;
            if (tag == null) {
                return null;
            }
            String tagValue = tag.getValue();
            if (tagValue.startsWith("tag:yaml.org,2002:") && ((className = tagValue.substring("tag:yaml.org,2002:".length())).contains(".") || className.contains("$"))) {
                return className;
            }
            return tagValue;
        }
    }
}

