/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URL;
import java.time.Duration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.client.DefaultCredentialsResolver;
import org.redisson.config.CommandMapper;
import org.redisson.config.ConstantDelay;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.DefaultCommandMapper;
import org.redisson.config.DefaultNameMapper;
import org.redisson.config.DelayStrategy;
import org.redisson.config.EqualJitterDelay;
import org.redisson.config.NameMapper;
import org.redisson.config.SslProvider;
import org.redisson.config.SslVerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfig<T extends BaseConfig<T>> {
    protected static final Logger log = LoggerFactory.getLogger("config");
    private int idleConnectionTimeout = 10000;
    private int connectTimeout = 10000;
    private int timeout = 3000;
    private int subscriptionTimeout = 7500;
    private int retryAttempts = 4;
    @Deprecated
    private int retryInterval = 1500;
    private DelayStrategy retryDelay = new EqualJitterDelay(Duration.ofMillis(1000L), Duration.ofSeconds(2L));
    private DelayStrategy reconnectionDelay = new EqualJitterDelay(Duration.ofMillis(100L), Duration.ofSeconds(10L));
    @Deprecated
    private String password;
    @Deprecated
    private String username;
    @Deprecated
    private CredentialsResolver credentialsResolver = new DefaultCredentialsResolver();
    private int subscriptionsPerConnection = 5;
    private String clientName;
    @Deprecated
    private SslVerificationMode sslVerificationMode = SslVerificationMode.STRICT;
    @Deprecated
    private String sslKeystoreType;
    @Deprecated
    private SslProvider sslProvider = SslProvider.JDK;
    @Deprecated
    private URL sslTruststore;
    @Deprecated
    private String sslTruststorePassword;
    @Deprecated
    private URL sslKeystore;
    @Deprecated
    private String sslKeystorePassword;
    @Deprecated
    private String[] sslProtocols;
    @Deprecated
    private String[] sslCiphers;
    @Deprecated
    private TrustManagerFactory sslTrustManagerFactory;
    @Deprecated
    private KeyManagerFactory sslKeyManagerFactory;
    private int pingConnectionInterval = 30000;
    @Deprecated
    private boolean keepAlive;
    @Deprecated
    private int tcpKeepAliveCount;
    @Deprecated
    private int tcpKeepAliveIdle;
    @Deprecated
    private int tcpKeepAliveInterval;
    @Deprecated
    private int tcpUserTimeout;
    @Deprecated
    private boolean tcpNoDelay = true;
    @Deprecated
    private NameMapper nameMapper = NameMapper.direct();
    @Deprecated
    private CommandMapper commandMapper = CommandMapper.direct();

    BaseConfig() {
    }

    BaseConfig(T config) {
        if (((BaseConfig)config).getUsername() != null) {
            this.setUsername(((BaseConfig)config).getUsername());
        }
        if (((BaseConfig)config).getPassword() != null) {
            this.setPassword(((BaseConfig)config).getPassword());
        }
        if (!(((BaseConfig)config).getNameMapper() instanceof DefaultNameMapper)) {
            this.setNameMapper(((BaseConfig)config).getNameMapper());
        }
        if (!(((BaseConfig)config).getCommandMapper() instanceof DefaultCommandMapper)) {
            this.setCommandMapper(((BaseConfig)config).getCommandMapper());
        }
        if (!(((BaseConfig)config).getCredentialsResolver() instanceof DefaultCredentialsResolver)) {
            this.setCredentialsResolver(((BaseConfig)config).getCredentialsResolver());
        }
        if (((BaseConfig)config).getSslVerificationMode() != SslVerificationMode.STRICT) {
            this.setSslVerificationMode(((BaseConfig)config).getSslVerificationMode());
        }
        if (((BaseConfig)config).getSslKeystoreType() != null) {
            this.setSslKeystoreType(((BaseConfig)config).getSslKeystoreType());
        }
        if (((BaseConfig)config).getSslProvider() != SslProvider.JDK) {
            this.setSslProvider(((BaseConfig)config).getSslProvider());
        }
        if (((BaseConfig)config).getSslTruststore() != null) {
            this.setSslTruststore(((BaseConfig)config).getSslTruststore());
        }
        if (((BaseConfig)config).getSslTruststorePassword() != null) {
            this.setSslTruststorePassword(((BaseConfig)config).getSslTruststorePassword());
        }
        if (((BaseConfig)config).getSslKeystore() != null) {
            this.setSslKeystore(((BaseConfig)config).getSslKeystore());
        }
        if (((BaseConfig)config).getSslKeystorePassword() != null) {
            this.setSslKeystorePassword(((BaseConfig)config).getSslKeystorePassword());
        }
        if (((BaseConfig)config).getSslProtocols() != null) {
            this.setSslProtocols(((BaseConfig)config).getSslProtocols());
        }
        if (((BaseConfig)config).getSslCiphers() != null) {
            this.setSslCiphers(((BaseConfig)config).getSslCiphers());
        }
        if (((BaseConfig)config).getSslKeyManagerFactory() != null) {
            this.setSslKeyManagerFactory(((BaseConfig)config).getSslKeyManagerFactory());
        }
        if (((BaseConfig)config).getSslTrustManagerFactory() != null) {
            this.setSslTrustManagerFactory(((BaseConfig)config).getSslTrustManagerFactory());
        }
        if (((BaseConfig)config).isKeepAlive()) {
            this.setKeepAlive(((BaseConfig)config).isKeepAlive());
        }
        if (((BaseConfig)config).getTcpKeepAliveCount() != 0) {
            this.setTcpKeepAliveCount(((BaseConfig)config).getTcpKeepAliveCount());
        }
        if (((BaseConfig)config).getTcpKeepAliveIdle() != 0) {
            this.setTcpKeepAliveIdle(((BaseConfig)config).getTcpKeepAliveIdle());
        }
        if (((BaseConfig)config).getTcpKeepAliveInterval() != 0) {
            this.setTcpKeepAliveInterval(((BaseConfig)config).getTcpKeepAliveInterval());
        }
        if (((BaseConfig)config).getTcpUserTimeout() != 0) {
            this.setTcpUserTimeout(((BaseConfig)config).getTcpUserTimeout());
        }
        if (!((BaseConfig)config).isTcpNoDelay()) {
            this.setTcpNoDelay(((BaseConfig)config).isTcpNoDelay());
        }
        this.setSubscriptionsPerConnection(((BaseConfig)config).getSubscriptionsPerConnection());
        this.setRetryAttempts(((BaseConfig)config).getRetryAttempts());
        this.setRetryDelay(((BaseConfig)config).getRetryDelay());
        this.setReconnectionDelay(((BaseConfig)config).getReconnectionDelay());
        this.setTimeout(((BaseConfig)config).getTimeout());
        this.setClientName(((BaseConfig)config).getClientName());
        this.setConnectTimeout(((BaseConfig)config).getConnectTimeout());
        this.setIdleConnectionTimeout(((BaseConfig)config).getIdleConnectionTimeout());
        this.setPingConnectionInterval(((BaseConfig)config).getPingConnectionInterval());
        this.setSubscriptionTimeout(((BaseConfig)config).getSubscriptionTimeout());
    }

    public T setSubscriptionsPerConnection(int subscriptionsPerConnection) {
        this.subscriptionsPerConnection = subscriptionsPerConnection;
        return (T)this;
    }

    public int getSubscriptionsPerConnection() {
        return this.subscriptionsPerConnection;
    }

    @Deprecated
    public T setPassword(String password) {
        log.warn("password setting is deprecated. Use password setting in Config instead.");
        this.password = password;
        return (T)this;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    public T setUsername(String username) {
        log.warn("username setting is deprecated. Use username setting in object instead.");
        this.username = username;
        return (T)this;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    public T setRetryAttempts(int retryAttempts) {
        if (retryAttempts < 0 || retryAttempts == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("retryAttempts setting can't be negative or MAX_VALUE");
        }
        this.retryAttempts = retryAttempts;
        return (T)this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @Deprecated
    public T setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        this.retryDelay = new ConstantDelay(Duration.ofMillis(retryInterval));
        return (T)this;
    }

    @Deprecated
    public int getRetryInterval() {
        return this.retryInterval;
    }

    public T setTimeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    public T setSubscriptionTimeout(int subscriptionTimeout) {
        this.subscriptionTimeout = subscriptionTimeout;
        return (T)this;
    }

    public T setClientName(String clientName) {
        this.clientName = clientName;
        return (T)this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public T setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (T)this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public T setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return (T)this;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Deprecated
    public boolean isSslEnableEndpointIdentification() {
        return this.sslVerificationMode == SslVerificationMode.STRICT;
    }

    @Deprecated
    public T setSslEnableEndpointIdentification(boolean sslEnableEndpointIdentification) {
        log.warn("sslEnableEndpointIdentification setting is deprecated. Use sslVerificationMode setting instead.");
        this.sslVerificationMode = sslEnableEndpointIdentification ? SslVerificationMode.STRICT : SslVerificationMode.NONE;
        return (T)this;
    }

    @Deprecated
    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    @Deprecated
    public T setSslProvider(SslProvider sslProvider) {
        log.warn("sslProvider setting is deprecated. Use sslProvider setting in Config instead.");
        this.sslProvider = sslProvider;
        return (T)this;
    }

    @Deprecated
    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    @Deprecated
    public T setSslTruststore(URL sslTruststore) {
        log.warn("sslTruststore setting is deprecated. Use sslTruststore setting in Config instead.");
        this.sslTruststore = sslTruststore;
        return (T)this;
    }

    @Deprecated
    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    @Deprecated
    public T setSslTruststorePassword(String sslTruststorePassword) {
        log.warn("sslTruststorePassword setting is deprecated. Use sslTruststorePassword setting in Config instead.");
        this.sslTruststorePassword = sslTruststorePassword;
        return (T)this;
    }

    @Deprecated
    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    @Deprecated
    public T setSslKeystore(URL sslKeystore) {
        log.warn("sslKeystore setting is deprecated. Use sslKeystore setting in Config instead.");
        this.sslKeystore = sslKeystore;
        return (T)this;
    }

    @Deprecated
    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Deprecated
    public T setSslKeystorePassword(String sslKeystorePassword) {
        log.warn("sslKeystorePassword setting is deprecated. Use sslKeystorePassword setting in Config instead.");
        this.sslKeystorePassword = sslKeystorePassword;
        return (T)this;
    }

    @Deprecated
    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    @Deprecated
    public T setSslProtocols(String[] sslProtocols) {
        log.warn("sslProtocols setting is deprecated. Use sslProtocols setting in Config instead.");
        this.sslProtocols = sslProtocols;
        return (T)this;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public T setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
        return (T)this;
    }

    @Deprecated
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Deprecated
    public T setKeepAlive(boolean keepAlive) {
        log.warn("setKeepAlive setting is deprecated. Use setTcpKeepAlive setting in Config instead.");
        this.keepAlive = keepAlive;
        return (T)this;
    }

    @Deprecated
    public int getTcpKeepAliveCount() {
        return this.tcpKeepAliveCount;
    }

    @Deprecated
    public T setTcpKeepAliveCount(int tcpKeepAliveCount) {
        log.warn("setTcpKeepAliveCount setting is deprecated. Use setTcpKeepAliveCount setting in Config instead.");
        this.tcpKeepAliveCount = tcpKeepAliveCount;
        return (T)this;
    }

    @Deprecated
    public int getTcpKeepAliveIdle() {
        return this.tcpKeepAliveIdle;
    }

    @Deprecated
    public T setTcpKeepAliveIdle(int tcpKeepAliveIdle) {
        log.warn("setTcpKeepAliveIdle setting is deprecated. Use setTcpKeepAliveIdle setting in Config instead.");
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
        return (T)this;
    }

    @Deprecated
    public int getTcpKeepAliveInterval() {
        return this.tcpKeepAliveInterval;
    }

    @Deprecated
    public T setTcpKeepAliveInterval(int tcpKeepAliveInterval) {
        log.warn("setTcpKeepAliveInterval setting is deprecated. Use setTcpKeepAliveInterval setting in Config instead.");
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
        return (T)this;
    }

    @Deprecated
    public int getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    @Deprecated
    public T setTcpUserTimeout(int tcpUserTimeout) {
        log.warn("setTcpUserTimeout setting is deprecated. Use setTcpUserTimeout setting in Config instead.");
        this.tcpUserTimeout = tcpUserTimeout;
        return (T)this;
    }

    @Deprecated
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Deprecated
    public T setTcpNoDelay(boolean tcpNoDelay) {
        log.warn("setTcpNoDelay setting is deprecated. Use setTcpNoDelay setting in Config instead.");
        this.tcpNoDelay = tcpNoDelay;
        return (T)this;
    }

    @Deprecated
    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    @Deprecated
    public T setNameMapper(NameMapper nameMapper) {
        log.warn("nameMapper setting is deprecated. Use nameMapper setting in Config instead.");
        this.nameMapper = nameMapper;
        return (T)this;
    }

    @Deprecated
    public CredentialsResolver getCredentialsResolver() {
        return this.credentialsResolver;
    }

    @Deprecated
    public T setCredentialsResolver(CredentialsResolver credentialsResolver) {
        log.warn("credentialsResolver setting is deprecated. Use credentialsResolver setting in Config instead.");
        this.credentialsResolver = credentialsResolver;
        return (T)this;
    }

    @Deprecated
    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    @Deprecated
    public T setSslKeystoreType(String sslKeystoreType) {
        log.warn("sslKeystoreType setting is deprecated. Use sslKeystoreType setting in Config instead.");
        this.sslKeystoreType = sslKeystoreType;
        return (T)this;
    }

    @Deprecated
    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    @Deprecated
    public T setSslCiphers(String[] sslCiphers) {
        log.warn("sslCiphers setting is deprecated. Use sslCiphers setting in Config instead.");
        this.sslCiphers = sslCiphers;
        return (T)this;
    }

    @Deprecated
    public TrustManagerFactory getSslTrustManagerFactory() {
        return this.sslTrustManagerFactory;
    }

    @Deprecated
    public T setSslTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        log.warn("trustManagerFactory setting is deprecated. Use trustManagerFactory setting in Config instead.");
        this.sslTrustManagerFactory = trustManagerFactory;
        return (T)this;
    }

    @Deprecated
    public KeyManagerFactory getSslKeyManagerFactory() {
        return this.sslKeyManagerFactory;
    }

    @Deprecated
    public BaseConfig<T> setSslKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        log.warn("keyManagerFactory setting is deprecated. Use keyManagerFactory setting in Config instead.");
        this.sslKeyManagerFactory = keyManagerFactory;
        return this;
    }

    @Deprecated
    public CommandMapper getCommandMapper() {
        return this.commandMapper;
    }

    @Deprecated
    public T setCommandMapper(CommandMapper commandMapper) {
        log.warn("commandMapper setting is deprecated. Use commandMapper setting in Config instead.");
        this.commandMapper = commandMapper;
        return (T)this;
    }

    @Deprecated
    public SslVerificationMode getSslVerificationMode() {
        return this.sslVerificationMode;
    }

    @Deprecated
    public T setSslVerificationMode(SslVerificationMode sslVerificationMode) {
        log.warn("sslVerificationMode setting is deprecated. Use sslVerificationMode setting in Config instead.");
        this.sslVerificationMode = sslVerificationMode;
        return (T)this;
    }

    public DelayStrategy getRetryDelay() {
        return this.retryDelay;
    }

    public T setRetryDelay(DelayStrategy retryDelay) {
        this.retryDelay = retryDelay;
        return (T)this;
    }

    public DelayStrategy getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public T setReconnectionDelay(DelayStrategy reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
        return (T)this;
    }
}

