/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisRetryException;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnectionHandler<C extends RedisConnection>
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(BaseConnectionHandler.class);
    final RedisClient redisClient;
    final CompletableFuture<C> connectionPromise = new CompletableFuture();
    C connection;

    public BaseConnectionHandler(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection(ctx);
        }
        super.channelRegistered(ctx);
    }

    abstract C createConnection(ChannelHandlerContext var1);

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        Future<Object> future;
        ArrayList futures = new ArrayList(5);
        CompletableFuture<Void> f = this.authWithCredential();
        futures.add(f);
        RedisClientConfig config = this.redisClient.getConfig();
        if (config.getProtocol() == Protocol.RESP3) {
            RFuture f1 = ((RedisConnection)this.connection).async(RedisCommands.HELLO, "3");
            futures.add(f1.toCompletableFuture());
        }
        if (config.getDatabase() != 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.SELECT, config.getDatabase());
            futures.add(future.toCompletableFuture());
        }
        if (config.getClientName() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_SETNAME, config.getClientName());
            futures.add(future.toCompletableFuture());
        }
        if (!config.getCapabilities().isEmpty()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_CAPA, config.getCapabilities().toArray());
            futures.add(future.toCompletableFuture());
        }
        if (config.isReadOnly()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.READONLY, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        if (config.getPingConnectionInterval() > 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.PING, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)future).whenComplete((res, e) -> {
            if (e != null) {
                if (e instanceof RedisRetryException) {
                    ctx.executor().schedule(() -> this.channelActive(ctx), 1L, TimeUnit.SECONDS);
                    return;
                }
                ((RedisConnection)this.connection).closeAsync();
                this.connectionPromise.completeExceptionally((Throwable)e);
                return;
            }
            this.startRenewal(ctx, config);
            ctx.fireChannelActive();
            this.connectionPromise.complete(this.connection);
        });
    }

    private CompletionStage<Void> startRenewal(ChannelHandlerContext ctx, RedisClientConfig config) {
        if (BaseConnectionHandler.isClosed(ctx, this.connection)) {
            return CompletableFuture.completedFuture(null);
        }
        return config.getCredentialsResolver().nextRenewal().thenCompose(r -> {
            QueueCommand currentCommand = ((RedisConnection)this.connection).getCurrentCommandData();
            if (currentCommand != null && currentCommand.isBlockingCommand()) {
                return ((RedisConnection)this.connection).forceFastReconnectAsync();
            }
            return this.authWithCredential();
        }).thenCompose(r -> this.startRenewal(ctx, config)).exceptionally(cause -> {
            if (BaseConnectionHandler.isClosed(ctx, this.connection)) {
                return null;
            }
            if (!(cause instanceof RedisRetryException)) {
                log.error("Unable to send AUTH command over channel: {}", (Object)ctx.channel(), cause);
                log.debug("channel: {} closed due to AUTH error response", (Object)ctx.channel());
                ctx.channel().close();
                return null;
            }
            log.warn("Renewal cycle failed, retrying", (Throwable)cause);
            config.getTimer().newTimeout(t -> this.startRenewal(ctx, config), 1L, TimeUnit.SECONDS);
            return null;
        });
    }

    private CompletableFuture<Void> authWithCredential() {
        RedisClientConfig config = this.redisClient.getConfig();
        InetSocketAddress addr = this.redisClient.resolveAddr().getNow(null);
        CompletionStage f = config.getCredentialsResolver().resolve(addr).thenCompose(credentials -> {
            String password = Objects.toString(config.getAddress().getPassword(), Objects.toString(credentials.getPassword(), config.getPassword()));
            if (password != null) {
                String username = Objects.toString(config.getAddress().getUsername(), Objects.toString(credentials.getUsername(), config.getUsername()));
                RFuture future = username != null ? ((RedisConnection)this.connection).async(RedisCommands.AUTH, username, password) : ((RedisConnection)this.connection).async(RedisCommands.AUTH, password);
                return future;
            }
            return CompletableFuture.completedFuture(null);
        });
        return f.toCompletableFuture();
    }

    protected Throwable cause(CompletableFuture<?> future) {
        try {
            future.toCompletableFuture().getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    private static boolean isClosed(ChannelHandlerContext ctx, RedisConnection connection) {
        return connection.isClosed() || !ctx.channel().equals(connection.getChannel()) || ctx.isRemoved() || connection.getRedisClient().isShutdown();
    }
}

