/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.pubsub;

import org.redisson.api.pubsub.Position;

public final class PositionValue
implements Position {
    private static final String MAX_MESSAGES_PER_MILLISECOND = "9999999";
    private boolean latest;
    private boolean exclusive;
    private String messageId;
    private long timestamp;

    public PositionValue(boolean latest) {
        this.latest = latest;
    }

    public PositionValue(String messageId, boolean exclusive) {
        this.messageId = messageId;
        this.exclusive = exclusive;
    }

    public PositionValue(long timestamp, boolean exclusive) {
        this.timestamp = timestamp;
        this.exclusive = exclusive;
    }

    public String toString() {
        if (this.timestamp > 0L) {
            if (this.exclusive) {
                return this.timestamp + "-" + MAX_MESSAGES_PER_MILLISECOND;
            }
            return this.timestamp - 1L + "-" + MAX_MESSAGES_PER_MILLISECOND;
        }
        if (this.messageId != null) {
            if (this.exclusive) {
                return "(" + this.messageId;
            }
            return "[" + this.messageId;
        }
        if (this.latest) {
            return "$";
        }
        return "0-0";
    }
}

