/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.List;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonDeque;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonStream;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNode;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDoubleReactive;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.api.RBatchReactive;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RBlockingDequeReactive;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RDequeReactive;
import org.redisson.api.RGeoReactive;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.api.RKeysReactive;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.api.RListMultimapReactive;
import org.redisson.api.RListReactive;
import org.redisson.api.RLockReactive;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RPatternTopicReactive;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RQueueReactive;
import org.redisson.api.RRateLimiterReactive;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.api.RScriptReactive;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetMultimapReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.RStreamReactive;
import org.redisson.api.RTopicReactive;
import org.redisson.api.RTransactionReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.pubsub.SemaphorePubSub;
import org.redisson.reactive.CommandReactiveService;
import org.redisson.reactive.ReactiveProxyBuilder;
import org.redisson.reactive.RedissonBatchReactive;
import org.redisson.reactive.RedissonBlockingDequeReactive;
import org.redisson.reactive.RedissonBlockingQueueReactive;
import org.redisson.reactive.RedissonKeysReactive;
import org.redisson.reactive.RedissonLexSortedSetReactive;
import org.redisson.reactive.RedissonListMultimapReactive;
import org.redisson.reactive.RedissonListReactive;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonReadWriteLockReactive;
import org.redisson.reactive.RedissonScoredSortedSetReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetMultimapReactive;
import org.redisson.reactive.RedissonSetReactive;
import org.redisson.reactive.RedissonTopicReactive;
import org.redisson.reactive.RedissonTransactionReactive;

public class RedissonReactive
implements RedissonReactiveClient {
    protected final EvictionScheduler evictionScheduler;
    protected final CommandReactiveService commandExecutor;
    protected final ConnectionManager connectionManager;
    protected final Config config;
    protected final ReferenceCodecProvider codecProvider;
    protected final SemaphorePubSub semaphorePubSub = new SemaphorePubSub();

    protected RedissonReactive(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        this.commandExecutor = new CommandReactiveService(this.connectionManager);
        this.evictionScheduler = new EvictionScheduler(this.commandExecutor);
        this.codecProvider = config.getReferenceCodecProvider();
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonStream(this.commandExecutor, name), RStreamReactive.class);
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonStream(codec, this.commandExecutor, name), RStreamReactive.class);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonGeo(this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(this.commandExecutor, name), RGeoReactive.class);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonGeo(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(codec, this.commandExecutor, name), RGeoReactive.class);
    }

    @Override
    public RLockReactive getFairLock(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor, name), RLockReactive.class);
    }

    @Override
    public RRateLimiterReactive getRateLimiter(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor, name), RRateLimiterReactive.class);
    }

    @Override
    public RSemaphoreReactive getSemaphore(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(this.commandExecutor, name, this.semaphorePubSub), RSemaphoreReactive.class);
    }

    @Override
    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(this.commandExecutor, name, this.semaphorePubSub), RPermitExpirableSemaphoreReactive.class);
    }

    @Override
    public RReadWriteLockReactive getReadWriteLock(String name) {
        return new RedissonReadWriteLockReactive(this.commandExecutor, name);
    }

    @Override
    public RLockReactive getLock(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonLock(this.commandExecutor, name), RLockReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBucket(this.commandExecutor, name), RBucketReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBucket(codec, this.commandExecutor, name), RBucketReactive.class);
    }

    @Override
    public <V> List<RBucketReactive<V>> findBuckets(String pattern) {
        RedissonKeys redissonKeys = new RedissonKeys(this.commandExecutor);
        Iterable<String> keys = redissonKeys.getKeysByPattern(pattern);
        ArrayList<RBucketReactive<V>> buckets = new ArrayList<RBucketReactive<V>>();
        for (String key : keys) {
            if (key == null) continue;
            buckets.add(this.getBucket(key.toString()));
        }
        return buckets;
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(this.commandExecutor, name), RHyperLogLogReactive.class);
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(codec, this.commandExecutor, name), RHyperLogLogReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonList(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RListReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonList(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RListReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(this.commandExecutor, name), new RedissonListMultimapReactive(this.commandExecutor, name), RListMultimapReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(codec, this.commandExecutor, name), new RedissonListMultimapReactive(codec, this.commandExecutor, name), RListMultimapReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(this.commandExecutor, name), new RedissonSetMultimapReactive(this.commandExecutor, name), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(codec, this.commandExecutor, name), new RedissonSetMultimapReactive(codec, this.commandExecutor, name), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.commandExecutor, name, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive(map), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.commandExecutor, name, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive(map), RMapReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetReactive(set), RSetReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetReactive(set), RSetReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScoredSortedSet(this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(this.commandExecutor, name), RScoredSortedSetReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScoredSortedSet(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(codec, this.commandExecutor, name), RScoredSortedSetReactive.class);
    }

    @Override
    public RLexSortedSetReactive getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetReactive(set), RLexSortedSetReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name) {
        RedissonTopic topic = new RedissonTopic(this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicReactive(topic), RTopicReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name, Codec codec) {
        RedissonTopic topic = new RedissonTopic(codec, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicReactive(topic), RTopicReactive.class);
    }

    @Override
    public RPatternTopicReactive getPatternTopic(String pattern) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(this.commandExecutor, pattern), RPatternTopicReactive.class);
    }

    @Override
    public RPatternTopicReactive getPatternTopic(String pattern, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(codec, this.commandExecutor, pattern), RPatternTopicReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonQueue(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RQueueReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonQueue(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RQueueReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueReactive(queue), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name, Codec codec) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueReactive(queue), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonDeque(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RDequeReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonDeque(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RDequeReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheReactive(set), RSetCacheReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheReactive(set), RSetCacheReactive.class);
    }

    @Override
    public RAtomicLongReactive getAtomicLong(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(this.commandExecutor, name), RAtomicLongReactive.class);
    }

    @Override
    public RAtomicDoubleReactive getAtomicDouble(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(this.commandExecutor, name), RAtomicDoubleReactive.class);
    }

    @Override
    public RBitSetReactive getBitSet(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBitSet(this.commandExecutor, name), RBitSetReactive.class);
    }

    @Override
    public RScriptReactive getScript() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor), RScriptReactive.class);
    }

    @Override
    public RScriptReactive getScript(Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor, codec), RScriptReactive.class);
    }

    @Override
    public RBatchReactive createBatch(BatchOptions options) {
        RedissonBatchReactive batch = new RedissonBatchReactive(this.evictionScheduler, this.connectionManager, this.commandExecutor, options);
        if (this.config.isReferenceEnabled()) {
            batch.enableRedissonReferenceSupport(this);
        }
        return batch;
    }

    @Override
    public RBatchReactive createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RKeysReactive getKeys() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonKeys(this.commandExecutor), new RedissonKeysReactive(this.commandExecutor), RKeysReactive.class);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public ReferenceCodecProvider getCodecProvider() {
        return this.codecProvider;
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager);
    }

    @Override
    public void shutdown() {
        this.connectionManager.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.isShuttingDown();
    }

    protected void enableRedissonReferenceSupport() {
        this.commandExecutor.enableRedissonReferenceSupport(this);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, null, options);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive<K, V>(map), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, options);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive<K, V>(map), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(this.commandExecutor, name, null, options);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive<K, V>(map), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(codec, this.commandExecutor, name, null, options);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive<K, V>(map), RMapReactive.class);
    }

    @Override
    public RTransactionReactive createTransaction(TransactionOptions options) {
        return new RedissonTransactionReactive(this.commandExecutor, options);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeReactive(deque), RBlockingDequeReactive.class);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name, Codec codec) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeReactive(deque), RBlockingDequeReactive.class);
    }
}

