/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RedissonListReactive<V> {
    private final RedissonList<V> instance;

    public RedissonListReactive(CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(commandExecutor, name, null);
    }

    public RedissonListReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(codec, commandExecutor, name, null);
    }

    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        return Flux.create(new Consumer<FluxSink<V>>(){

            @Override
            public void accept(final FluxSink<V> emitter) {
                emitter.onRequest(new LongConsumer(){
                    int currentIndex;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    public void accept(long value) {
                        this.onRequest(forward, emitter, value);
                    }

                    protected void onRequest(final boolean forward, final FluxSink<V> emitter2, final long n) {
                        RedissonListReactive.this.instance.getAsync(this.currentIndex).addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                if (!future.isSuccess()) {
                                    emitter2.error(future.cause());
                                    return;
                                }
                                Object value = future.getNow();
                                if (value != null) {
                                    emitter2.next(value);
                                    currentIndex = forward ? ++currentIndex : --currentIndex;
                                }
                                if (value == null) {
                                    emitter2.complete();
                                    return;
                                }
                                if (n - 1L == 0L) {
                                    return;
                                }
                                this.onRequest(forward, emitter2, n - 1L);
                            }
                        });
                    }
                });
            }
        });
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonListReactive.this.instance.addAsync(o);
            }
        }.addAll(c);
    }
}

