/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncExecutor;

abstract class EvictionTask
implements Runnable {
    final Deque<Integer> sizeHistory = new LinkedList<Integer>();
    final int minDelay = 5;
    final int maxDelay = 1800;
    final int keysLimit = 100;
    int delay = 5;
    final CommandAsyncExecutor executor;

    EvictionTask(CommandAsyncExecutor executor) {
        this.executor = executor;
    }

    public void schedule() {
        this.executor.getConnectionManager().getGroup().schedule(this, (long)this.delay, TimeUnit.SECONDS);
    }

    abstract RFuture<Integer> execute();

    @Override
    public void run() {
        if (this.executor.getConnectionManager().isShuttingDown()) {
            return;
        }
        RFuture<Integer> future = this.execute();
        future.addListener(new FutureListener<Integer>(){

            @Override
            public void operationComplete(Future<Integer> future) throws Exception {
                if (!future.isSuccess()) {
                    EvictionTask.this.schedule();
                    return;
                }
                Integer size = future.getNow();
                if (size == -1) {
                    EvictionTask.this.schedule();
                    return;
                }
                if (EvictionTask.this.sizeHistory.size() == 2) {
                    if (EvictionTask.this.sizeHistory.peekFirst() > EvictionTask.this.sizeHistory.peekLast() && EvictionTask.this.sizeHistory.peekLast() > size) {
                        EvictionTask.this.delay = Math.min(1800, (int)((double)EvictionTask.this.delay * 1.5));
                    }
                    if (EvictionTask.this.sizeHistory.peekFirst().intValue() == EvictionTask.this.sizeHistory.peekLast().intValue() && EvictionTask.this.sizeHistory.peekLast().intValue() == size.intValue()) {
                        if (size == 100) {
                            EvictionTask.this.delay = Math.max(5, EvictionTask.this.delay / 4);
                        }
                        if (size == 0) {
                            EvictionTask.this.delay = Math.min(1800, (int)((double)EvictionTask.this.delay * 1.5));
                        }
                    }
                    EvictionTask.this.sizeHistory.pollFirst();
                }
                EvictionTask.this.sizeHistory.add(size);
                EvictionTask.this.schedule();
            }
        });
    }
}

