/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.api.RFuture;
import org.redisson.api.RPatternTopicReactive;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.api.listener.PatternStatusListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

public class RedissonPatternTopicReactive<M>
implements RPatternTopicReactive<M> {
    final PublishSubscribeService subscribeService;
    final CommandReactiveExecutor commandExecutor;
    private final String name;
    private final ChannelName channelName;
    private final Codec codec;

    public RedissonPatternTopicReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public RedissonPatternTopicReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.channelName = new ChannelName(name);
        this.codec = codec;
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    @Override
    public Publisher<Integer> addListener(final PatternStatusListener listener) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                RedissonPromise<Integer> promise = new RedissonPromise<Integer>();
                RedissonPatternTopicReactive.this.addListener(new PubSubPatternStatusListener(listener, RedissonPatternTopicReactive.this.name), promise);
                return promise;
            }
        });
    }

    @Override
    public Publisher<Integer> addListener(final PatternMessageListener<M> listener) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                RedissonPromise<Integer> promise = new RedissonPromise<Integer>();
                PubSubPatternMessageListener pubSubListener = new PubSubPatternMessageListener(listener, RedissonPatternTopicReactive.this.name);
                RedissonPatternTopicReactive.this.addListener(pubSubListener, promise);
                return promise;
            }
        });
    }

    private void addListener(final RedisPubSubListener<M> pubSubListener, final RPromise<Integer> promise) {
        RFuture<PubSubConnectionEntry> future = this.subscribeService.psubscribe(this.channelName, this.codec, pubSubListener);
        future.addListener(new FutureListener<PubSubConnectionEntry>(){

            @Override
            public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                promise.trySuccess(pubSubListener.hashCode());
            }
        });
    }

    protected void acquire(AsyncSemaphore semaphore) {
        MasterSlaveServersConfig config = this.commandExecutor.getConnectionManager().getConfig();
        int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
        if (!semaphore.tryAcquire(timeout)) {
            throw new RedisTimeoutException("Remove listeners operation timeout: (" + timeout + "ms) for " + this.name + " topic");
        }
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.subscribeService.getSemaphore(this.channelName);
        this.acquire(semaphore);
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.channelName, listenerId);
        if (!entry.hasListeners(this.channelName)) {
            this.subscribeService.punsubscribe(this.channelName, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public List<String> getPatternNames() {
        return Collections.singletonList(this.name);
    }
}

