/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonBlockingDeque;
import org.redisson.api.RBlockingDequeAsync;
import org.redisson.api.RBlockingDequeReactive;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonBlockingQueueReactive;
import org.redisson.reactive.RedissonDequeReactive;

public class RedissonBlockingDequeReactive<V>
extends RedissonDequeReactive<V>
implements RBlockingDequeReactive<V> {
    private final RBlockingDequeAsync<V> instance;
    private final RBlockingQueueReactive<V> blockingQueue;

    public RedissonBlockingDequeReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.blockingQueue = new RedissonBlockingQueueReactive(commandExecutor, name);
        this.instance = new RedissonBlockingDeque(commandExecutor, name, null);
    }

    public RedissonBlockingDequeReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.blockingQueue = new RedissonBlockingQueueReactive(codec, commandExecutor, name);
        this.instance = new RedissonBlockingDeque(codec, commandExecutor, name, null);
    }

    @Override
    public Publisher<Integer> put(V e) {
        return this.offer(e);
    }

    @Override
    public Publisher<V> take() {
        return this.blockingQueue.take();
    }

    @Override
    public Publisher<V> poll(long timeout, TimeUnit unit) {
        return this.blockingQueue.poll(timeout, unit);
    }

    @Override
    public Publisher<V> pollFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        return this.blockingQueue.pollFromAny(timeout, unit, queueNames);
    }

    @Override
    public Publisher<V> pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) {
        return this.blockingQueue.pollLastAndOfferFirstTo(queueName, timeout, unit);
    }

    @Override
    public Publisher<Integer> drainTo(Collection<? super V> c) {
        return this.blockingQueue.drainTo(c);
    }

    @Override
    public Publisher<Integer> drainTo(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainTo(c, maxElements);
    }

    @Override
    public Publisher<V> pollFirstFromAny(final long timeout, final TimeUnit unit, final String ... queueNames) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.pollFirstFromAnyAsync(timeout, unit, queueNames);
            }
        });
    }

    @Override
    public Publisher<V> pollLastFromAny(final long timeout, final TimeUnit unit, final String ... queueNames) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.pollLastFromAnyAsync(timeout, unit, queueNames);
            }
        });
    }

    @Override
    public Publisher<Void> putFirst(final V e) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBlockingDequeReactive.this.instance.putFirstAsync(e);
            }
        });
    }

    @Override
    public Publisher<Void> putLast(final V e) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBlockingDequeReactive.this.instance.putLastAsync(e);
            }
        });
    }

    @Override
    public Publisher<V> pollLast(final long timeout, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.pollLastAsync(timeout, unit);
            }
        });
    }

    @Override
    public Publisher<V> takeLast() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.takeLastAsync();
            }
        });
    }

    @Override
    public Publisher<V> pollFirst(final long timeout, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.pollFirstAsync(timeout, unit);
            }
        });
    }

    @Override
    public Publisher<V> takeFirst() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingDequeReactive.this.instance.takeFirstAsync();
            }
        });
    }
}

