/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.PendingEntry;
import org.redisson.api.PendingResult;
import org.redisson.api.RFuture;
import org.redisson.api.RStream;
import org.redisson.api.StreamId;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonStream<K, V>
extends RedissonExpirable
implements RStream<K, V> {
    public RedissonStream(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    public RedissonStream(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
    }

    protected void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
    }

    @Override
    public void createGroup(String groupName) {
        this.get(this.createGroupAsync(groupName));
    }

    @Override
    public RFuture<Void> createGroupAsync(String groupName) {
        return this.createGroupAsync(groupName, StreamId.NEWEST);
    }

    @Override
    public void createGroup(String groupName, StreamId id) {
        this.get(this.createGroupAsync(groupName, id));
    }

    @Override
    public RFuture<Void> createGroupAsync(String groupName, StreamId id) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP, "CREATE", this.getName(), groupName, id);
    }

    @Override
    public RFuture<Long> ackAsync(String groupName, StreamId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        params.add(groupName);
        for (StreamId id : ids) {
            params.add(id);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XACK, params.toArray());
    }

    @Override
    public Long ack(String groupName, StreamId ... id) {
        return this.get(this.ackAsync(groupName, id));
    }

    @Override
    public RFuture<PendingResult> listPendingAsync(String groupName) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING, this.getName(), groupName);
    }

    @Override
    public PendingResult listPending(String groupName) {
        return this.get(this.listPendingAsync(groupName));
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, StreamId startId, StreamId endId, int count, String consumerName) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getName(), groupName, startId, endId, count, consumerName);
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, StreamId startId, StreamId endId, int count) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getName(), groupName, startId, endId, count);
    }

    @Override
    public List<PendingEntry> listPending(String groupName, StreamId startId, StreamId endId, int count) {
        return this.get(this.listPendingAsync(groupName, startId, endId, count));
    }

    @Override
    public List<PendingEntry> listPending(String groupName, StreamId startId, StreamId endId, int count, String consumerName) {
        return this.get(this.listPendingAsync(groupName, startId, endId, count, consumerName));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> claimAsync(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        params.add(groupName);
        params.add(consumerName);
        params.add(idleTimeUnit.toMillis(idleTime));
        for (StreamId id : ids) {
            params.add(id.toString());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XCLAIM, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> claimPending(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamId ... ids) {
        return this.get(this.claimAsync(groupName, consumerName, idleTime, idleTimeUnit, ids));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readGroupAsync(String groupName, String consumerName, StreamId ... ids) {
        return this.readGroupAsync(groupName, consumerName, 0, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readGroupAsync(String groupName, String consumerName, int count, StreamId ... ids) {
        return this.readGroupAsync(groupName, consumerName, count, 0L, null, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readGroupAsync(String groupName, String consumerName, long timeout, TimeUnit unit, StreamId ... ids) {
        return this.readGroupAsync(groupName, consumerName, 0, timeout, unit, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readGroupAsync(String groupName, String consumerName, int count, long timeout, TimeUnit unit, StreamId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(groupName);
        params.add(consumerName);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        if (timeout > 0L) {
            params.add("BLOCK");
            params.add(this.toSeconds(timeout, unit) * 1000L);
        }
        params.add("STREAMS");
        params.add(this.getName());
        if (ids.length == 0) {
            params.add(">");
        }
        for (StreamId id : ids) {
            params.add(id.toString());
        }
        if (timeout > 0L) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREADGROUP_BLOCKING_SINGLE, params.toArray());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREADGROUP_SINGLE, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> readGroup(String groupName, String consumerName, StreamId ... ids) {
        return this.get(this.readGroupAsync(groupName, consumerName, ids));
    }

    @Override
    public Map<StreamId, Map<K, V>> readGroup(String groupName, String consumerName, int count, StreamId ... ids) {
        return this.get(this.readGroupAsync(groupName, consumerName, count, ids));
    }

    @Override
    public Map<StreamId, Map<K, V>> readGroup(String groupName, String consumerName, long timeout, TimeUnit unit, StreamId ... ids) {
        return this.get(this.readGroupAsync(groupName, consumerName, timeout, unit, ids));
    }

    @Override
    public Map<StreamId, Map<K, V>> readGroup(String groupName, String consumerName, int count, long timeout, TimeUnit unit, StreamId ... ids) {
        return this.get(this.readGroupAsync(groupName, consumerName, count, timeout, unit, ids));
    }

    @Override
    public StreamId addAll(Map<K, V> entries) {
        return this.addAll(entries, 0, false);
    }

    @Override
    public RFuture<StreamId> addAllAsync(Map<K, V> entries) {
        return this.addAllAsync(entries, 0, false);
    }

    @Override
    public void addAll(StreamId id, Map<K, V> entries) {
        this.addAll(id, entries, 0, false);
    }

    @Override
    public RFuture<Void> addAllAsync(StreamId id, Map<K, V> entries) {
        return this.addAllAsync(id, entries, 0, false);
    }

    @Override
    public StreamId addAll(Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.get(this.addAllAsync(entries, trimLen, trimStrict));
    }

    @Override
    public RFuture<StreamId> addAllAsync(Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.addAllCustomAsync(null, entries, trimLen, trimStrict);
    }

    @Override
    public void addAll(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        this.get(this.addAllAsync(id, entries, trimLen, trimStrict));
    }

    private <R> RFuture<R> addAllCustomAsync(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        ArrayList<Object> params = new ArrayList<Object>(entries.size() * 2 + 1);
        params.add(this.getName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        for (Map.Entry<K, V> t : entries.entrySet()) {
            this.checkKey(t.getKey());
            this.checkValue(t.getValue());
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public RFuture<Void> addAllAsync(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.addAllCustomAsync(id, entries, trimLen, trimStrict);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XLEN, this.getName());
    }

    @Override
    public Map<StreamId, Map<K, V>> read(int count, StreamId ... ids) {
        return this.get(this.readAsync(count, ids));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, StreamId id, Map<String, StreamId> keyToId) {
        return this.readAsync(count, -1L, null, id, keyToId);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(int count, long timeout, TimeUnit unit, StreamId ... ids) {
        return this.get(this.readAsync(count, timeout, unit, ids));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, long timeout, TimeUnit unit, StreamId id, Map<String, StreamId> keyToId) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        if (timeout > 0L) {
            params.add("BLOCK");
            params.add(this.toSeconds(timeout, unit) * 1000L);
        }
        params.add("STREAMS");
        params.add(this.getName());
        for (String key : keyToId.keySet()) {
            params.add(key);
        }
        params.add(id);
        for (StreamId nextId : keyToId.values()) {
            params.add(nextId.toString());
        }
        if (timeout > 0L) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_BLOCKING, params.toArray());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD, params.toArray());
    }

    @Override
    public RFuture<StreamId> addAsync(K key, V value) {
        return this.addAsync(key, value, 0, false);
    }

    @Override
    public RFuture<Void> addAsync(StreamId id, K key, V value) {
        return this.addAsync(id, key, value, 0, false);
    }

    @Override
    public RFuture<StreamId> addAsync(K key, V value, int trimLen, boolean trimStrict) {
        return this.addCustomAsync(null, key, value, trimLen, trimStrict);
    }

    private <R> RFuture<R> addCustomAsync(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        this.checkKey(key);
        this.checkValue(value);
        params.add(this.encodeMapKey(key));
        params.add(this.encodeMapValue(value));
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public RFuture<Void> addAsync(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        return this.addCustomAsync(id, key, value, trimLen, trimStrict);
    }

    @Override
    public StreamId add(K key, V value) {
        return this.get(this.addAsync(key, value));
    }

    @Override
    public void add(StreamId id, K key, V value) {
        this.get(this.addAsync(id, key, value));
    }

    @Override
    public StreamId add(K key, V value, int trimLen, boolean trimStrict) {
        return this.get(this.addAsync(key, value, trimLen, trimStrict));
    }

    @Override
    public void add(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        this.get(this.addAsync(id, key, value, trimLen, trimStrict));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(int count, StreamId ... ids) {
        return this.readAsync(count, 0L, null, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(int count, long timeout, TimeUnit unit, StreamId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        if (timeout > 0L) {
            params.add("BLOCK");
            params.add(this.toSeconds(timeout, unit) * 1000L);
        }
        params.add("STREAMS");
        params.add(this.getName());
        for (StreamId id : ids) {
            params.add(id.toString());
        }
        if (timeout > 0L) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_BLOCKING_SINGLE, params.toArray());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_SINGLE, params.toArray());
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, StreamId id, Map<String, StreamId> keyToId) {
        return this.get(this.readAsync(count, id, keyToId));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, long timeout, TimeUnit unit, StreamId id, Map<String, StreamId> keyToId) {
        return this.get(this.readAsync(count, timeout, unit, id, keyToId));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeAsync(int count, StreamId startId, StreamId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XRANGE, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> range(int count, StreamId startId, StreamId endId) {
        return this.get(this.rangeAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeReversedAsync(int count, StreamId startId, StreamId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREVRANGE, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> rangeReversed(int count, StreamId startId, StreamId endId) {
        return this.get(this.rangeReversedAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(StreamId ... ids) {
        return this.readAsync(0, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(long timeout, TimeUnit unit, StreamId ... ids) {
        return this.readAsync(0, timeout, unit, ids);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(StreamId id, Map<String, StreamId> keyToId) {
        return this.readAsync(0, id, keyToId);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(long timeout, TimeUnit unit, StreamId id, Map<String, StreamId> keyToId) {
        return this.readAsync(0, timeout, unit, id, keyToId);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeAsync(StreamId startId, StreamId endId) {
        return this.rangeAsync(0, startId, endId);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeReversedAsync(StreamId startId, StreamId endId) {
        return this.rangeReversedAsync(0, startId, endId);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(StreamId ... ids) {
        return this.read(0, ids);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(long timeout, TimeUnit unit, StreamId ... ids) {
        return this.read(0, timeout, unit, ids);
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(StreamId id, Map<String, StreamId> keyToId) {
        return this.read(0, id, keyToId);
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(long timeout, TimeUnit unit, StreamId id, Map<String, StreamId> keyToId) {
        return this.read(0, timeout, unit, id, keyToId);
    }

    @Override
    public Map<StreamId, Map<K, V>> range(StreamId startId, StreamId endId) {
        return this.range(0, startId, endId);
    }

    @Override
    public Map<StreamId, Map<K, V>> rangeReversed(StreamId startId, StreamId endId) {
        return this.rangeReversed(0, startId, endId);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(StreamId id, String key2, StreamId id2) {
        return this.readAsync(id, Collections.singletonMap(key2, id2));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        HashMap<String, StreamId> params = new HashMap<String, StreamId>(2);
        params.put(key2, id2);
        params.put(key3, id3);
        return this.readAsync(id, params);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, StreamId id, String key2, StreamId id2) {
        return this.readAsync(count, id, Collections.singletonMap(key2, id2));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        HashMap<String, StreamId> params = new HashMap<String, StreamId>(2);
        params.put(key2, id2);
        params.put(key3, id3);
        return this.readAsync(count, id, params);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2) {
        return this.readAsync(timeout, unit, id, Collections.singletonMap(key2, id2));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        HashMap<String, StreamId> params = new HashMap<String, StreamId>(2);
        params.put(key2, id2);
        params.put(key3, id3);
        return this.readAsync(timeout, unit, id, params);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2) {
        return this.readAsync(count, timeout, unit, id, Collections.singletonMap(key2, id2));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        HashMap<String, StreamId> params = new HashMap<String, StreamId>(2);
        params.put(key2, id2);
        params.put(key3, id3);
        return this.readAsync(count, timeout, unit, id, params);
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(StreamId id, String key2, StreamId id2) {
        return this.get(this.readAsync(id, key2, id2));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        return this.get(this.readAsync(id, key2, id2, key3, id3));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, StreamId id, String key2, StreamId id2) {
        return this.get(this.readAsync(count, id, key2, id2));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        return this.get(this.readAsync(count, id, key2, id2, key3, id3));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2) {
        return this.get(this.readAsync(timeout, unit, id, key2, id2));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        return this.get(this.readAsync(timeout, unit, id, key2, id2, key3, id3));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2) {
        return this.get(this.readAsync(count, timeout, unit, id, key2, id2));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, long timeout, TimeUnit unit, StreamId id, String key2, StreamId id2, String key3, StreamId id3) {
        return this.get(this.readAsync(count, timeout, unit, id, key2, id2, key3, id3));
    }
}

