/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.redisson.PubSubEntry;
import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.RedissonObject;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.CountDownLatchPubSub;

public class RedissonCountDownLatch
extends RedissonObject
implements RCountDownLatch {
    public static final Long zeroCountMessage = 0L;
    public static final Long newCountMessage = 1L;
    private static final CountDownLatchPubSub PUBSUB = new CountDownLatchPubSub();
    private final UUID id;

    protected RedissonCountDownLatch(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.id = commandExecutor.getConnectionManager().getId();
    }

    @Override
    public void await() throws InterruptedException {
        RFuture<RedissonCountDownLatchEntry> future = this.subscribe();
        try {
            this.commandExecutor.syncSubscription(future);
            while (this.getCount() > 0L) {
                RedissonCountDownLatchEntry entry = this.getEntry();
                if (entry == null) continue;
                entry.getLatch().await();
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long remainTime = unit.toMillis(time);
        long current = System.currentTimeMillis();
        RFuture<RedissonCountDownLatchEntry> promise = this.subscribe();
        if (!this.await(promise, time, unit)) {
            return false;
        }
        try {
            if ((remainTime -= System.currentTimeMillis() - current) <= 0L) {
                boolean bl = false;
                return bl;
            }
            while (this.getCount() > 0L) {
                if (remainTime <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                RedissonCountDownLatchEntry entry = this.getEntry();
                if (entry != null) {
                    entry.getLatch().await(remainTime, TimeUnit.MILLISECONDS);
                }
                remainTime -= System.currentTimeMillis() - current;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unsubscribe(promise);
        }
    }

    private RedissonCountDownLatchEntry getEntry() {
        return (RedissonCountDownLatchEntry)PUBSUB.getEntry(this.getEntryName());
    }

    private RFuture<RedissonCountDownLatchEntry> subscribe() {
        return PUBSUB.subscribe(this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager().getSubscribeService());
    }

    private void unsubscribe(RFuture<RedissonCountDownLatchEntry> future) {
        PUBSUB.unsubscribe((PubSubEntry)future.getNow(), this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager().getSubscribeService());
    }

    @Override
    public void countDown() {
        this.get(this.countDownAsync());
    }

    @Override
    public RFuture<Void> countDownAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local v = redis.call('decr', KEYS[1]);if v <= 0 then redis.call('del', KEYS[1]) end;if v == 0 then redis.call('publish', KEYS[2], ARGV[1]) end;", Arrays.asList(this.getName(), this.getChannelName()), zeroCountMessage);
    }

    private String getEntryName() {
        return this.id + this.getName();
    }

    private String getChannelName() {
        return "redisson_countdownlatch__channel__{" + this.getName() + "}";
    }

    @Override
    public long getCount() {
        return this.get(this.getCountAsync());
    }

    @Override
    public RFuture<Long> getCountAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_LONG, this.getName());
    }

    @Override
    public boolean trySetCount(long count) {
        return this.get(this.trySetCountAsync(count));
    }

    @Override
    public RFuture<Boolean> trySetCountAsync(long count) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[1]) == 0 then redis.call('set', KEYS[1], ARGV[2]); redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getName(), this.getChannelName()), newCountMessage, count);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1]) == 1 then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getName(), this.getChannelName()), newCountMessage);
    }
}

