/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import java.util.concurrent.TimeUnit;
import org.redisson.RedissonSetCache;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class AddCacheOperation
extends TransactionalOperation {
    private Object value;
    private long ttl;
    private TimeUnit timeUnit;

    public AddCacheOperation(RObject set, Object value) {
        this(set, value, 0L, null);
    }

    public AddCacheOperation(RObject set, Object value, long ttl, TimeUnit timeUnit) {
        this(set.getName(), set.getCodec(), value, ttl, timeUnit);
    }

    public AddCacheOperation(String name, Codec codec, Object value, long ttl, TimeUnit timeUnit) {
        super(name, codec);
        this.value = value;
        this.timeUnit = timeUnit;
        this.ttl = ttl;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache<Object> set = new RedissonSetCache<Object>(this.codec, null, commandExecutor, this.name, null);
        if (this.timeUnit != null) {
            set.addAsync(this.value, this.ttl, this.timeUnit);
        } else {
            set.addAsync(this.value);
        }
        set.getLock(this.value).unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache<Object> set = new RedissonSetCache<Object>(this.codec, null, commandExecutor, this.name, null);
        set.getLock(this.value).unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getTTL() {
        return this.ttl;
    }
}

