/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.bucket.BucketCompareAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndDeleteOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketTrySetOperation;

public class RedissonTransactionalBucket<V>
extends RedissonBucket<V> {
    static final Object NULL = new Object();
    private long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private Object state;

    public RedissonTransactionalBucket(CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, AtomicBoolean executed) {
        super(commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
    }

    public RedissonTransactionalBucket(Codec codec, CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, AtomicBoolean executed) {
        super(codec, commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expireAt method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expireAt method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("moveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrateAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Long> sizeAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(0L);
            }
            ByteBuf buf = this.encode(this.state);
            long size = buf.readableBytes();
            buf.release();
            return RedissonPromise.newSucceededFuture(size);
        }
        return super.sizeAsync();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            return RedissonPromise.newSucceededFuture(true);
        }
        return super.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new TouchOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    result.trySuccess(RedissonTransactionalBucket.this.state != NULL);
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.operations.add(new TouchOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                        result.trySuccess(future.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new UnlinkOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        result.trySuccess(false);
                    } else {
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(true);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.operations.add(new UnlinkOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(future.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new DeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        result.trySuccess(false);
                    } else {
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(true);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.operations.add(new DeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(future.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            return RedissonPromise.newSucceededFuture(this.state);
        }
        return super.getAsync();
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(final V expect, final V update) {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new BucketCompareAndSetOperation<Object>(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), expect, update));
                    if (RedissonTransactionalBucket.this.state == NULL && expect == null || RedissonTransactionalBucket.this.isEquals(RedissonTransactionalBucket.this.state, expect)) {
                        if (update == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = update;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.operations.add(new BucketCompareAndSetOperation<Object>(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), expect, update));
                        if (future.getNow() == null && expect == null || RedissonTransactionalBucket.this.isEquals(future.getNow(), expect)) {
                            if (update == null) {
                                RedissonTransactionalBucket.this.state = NULL;
                            } else {
                                RedissonTransactionalBucket.this.state = update;
                            }
                            result.trySuccess(true);
                        } else {
                            result.trySuccess(false);
                        }
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAndSetAsync(final V newValue) {
        this.checkState();
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    Object prevValue = RedissonTransactionalBucket.this.state == NULL ? null : RedissonTransactionalBucket.this.state;
                    RedissonTransactionalBucket.this.operations.add(new BucketGetAndSetOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), newValue));
                    if (newValue == null) {
                        RedissonTransactionalBucket.this.state = NULL;
                    } else {
                        RedissonTransactionalBucket.this.state = newValue;
                    }
                    result.trySuccess(prevValue);
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (newValue == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = newValue;
                        }
                        RedissonTransactionalBucket.this.operations.add(new BucketGetAndSetOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), newValue));
                        result.trySuccess(future.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        this.checkState();
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    Object prevValue = RedissonTransactionalBucket.this.state == NULL ? null : RedissonTransactionalBucket.this.state;
                    RedissonTransactionalBucket.this.operations.add(new BucketGetAndDeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec()));
                    RedissonTransactionalBucket.this.state = NULL;
                    result.trySuccess(prevValue);
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.state = NULL;
                        RedissonTransactionalBucket.this.operations.add(new BucketGetAndDeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec()));
                        result.trySuccess(future.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> setAsync(V newValue) {
        return this.setAsync(newValue, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue));
    }

    private RFuture<Void> setAsync(final V newValue, final TransactionalOperation operation) {
        this.checkState();
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                RedissonTransactionalBucket.this.operations.add(operation);
                if (newValue == null) {
                    RedissonTransactionalBucket.this.state = NULL;
                } else {
                    RedissonTransactionalBucket.this.state = newValue;
                }
                result.trySuccess(null);
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.setAsync(value, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V newValue) {
        return this.trySet(newValue, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.trySet(value, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit));
    }

    private RFuture<Boolean> trySet(final V newValue, final TransactionalOperation operation) {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(operation);
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        if (newValue == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = newValue;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonTransactionalBucket.this.operations.add(operation);
                        if (future.getNow() == null) {
                            if (newValue == null) {
                                RedissonTransactionalBucket.this.state = NULL;
                            } else {
                                RedissonTransactionalBucket.this.state = newValue;
                            }
                            result.trySuccess(true);
                        } else {
                            result.trySuccess(false);
                        }
                    }
                });
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEquals(Object value, Object oldValue) {
        ByteBuf valueBuf = this.encode(value);
        ByteBuf oldValueBuf = this.encode(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> void executeLocked(final RPromise<R> promise, final Runnable runnable) {
        RLock lock = this.getLock();
        lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    runnable.run();
                } else {
                    promise.tryFailure(future.cause());
                }
            }
        });
    }

    private RLock getLock() {
        return new RedissonLock(this.commandExecutor, this.getLockName());
    }

    private String getLockName() {
        return this.getName() + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

