/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.Set;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.BaseTransactionalSet;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.set.AddOperation;
import org.redisson.transaction.operation.set.MoveOperation;
import org.redisson.transaction.operation.set.RemoveOperation;

public class TransactionalSet<V>
extends BaseTransactionalSet<V> {
    private final RSet<V> set;

    public TransactionalSet(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RSet<V> set) {
        super(commandExecutor, timeout, operations, set);
        this.set = set;
    }

    @Override
    protected ListScanResult<ScanObjectEntry> scanIteratorSource(String name, RedisClient client, long startPos, String pattern) {
        return ((RedissonSet)this.set).scanIterator(name, client, startPos, pattern);
    }

    @Override
    protected RFuture<Set<V>> readAllAsyncSource() {
        return this.set.readAllAsync();
    }

    @Override
    protected TransactionalOperation createAddOperation(V value) {
        return new AddOperation(this.set, value);
    }

    @Override
    protected MoveOperation createMoveOperation(String destination, V value, long threadId) {
        return new MoveOperation(this.set, destination, threadId, value);
    }

    @Override
    protected RLock getLock(V value) {
        return this.set.getLock(value);
    }

    @Override
    protected TransactionalOperation createRemoveOperation(Object value) {
        return new RemoveOperation(this.set, value);
    }
}

