/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import reactor.core.publisher.FluxSink;

public abstract class SetReactiveIterator<V>
implements Consumer<FluxSink<V>> {
    @Override
    public void accept(final FluxSink<V> emitter) {
        emitter.onRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(final FluxSink<V> emitter2) {
                SetReactiveIterator.this.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<ListScanResult<ScanObjectEntry>>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(ListScanResult<ScanObjectEntry> res) {
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (ScanObjectEntry val : res.getValues()) {
                            emitter2.next(val.getObj());
                            elementsRead.incrementAndGet();
                        }
                        if (elementsRead.get() >= readAmount.get()) {
                            emitter2.complete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (res.getPos() == 0L && !SetReactiveIterator.this.tryAgain()) {
                            finished = true;
                            emitter2.complete();
                        }
                    }

                    @Override
                    public void onError(Throwable error) {
                        emitter2.error(error);
                    }

                    @Override
                    public void onComplete() {
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues(emitter2);
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient var1, long var2);
}

