/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import org.redisson.config.SslProvider;
import org.redisson.misc.URIBuilder;

public class RedisClientConfig {
    private URI address;
    private InetSocketAddress addr;
    private Timer timer;
    private ExecutorService executor;
    private EventLoopGroup group;
    private DnsAddressResolverGroup resolverGroup;
    private Class<? extends SocketChannel> socketChannelClass = NioSocketChannel.class;
    private int connectTimeout = 10000;
    private int commandTimeout = 10000;
    private String password;
    private int database;
    private String clientName;
    private boolean readOnly;
    private boolean keepPubSubOrder = true;
    private int pingConnectionInterval;
    private boolean keepAlive;
    private boolean tcpNoDelay;
    private String sslHostname;
    private boolean sslEnableEndpointIdentification = true;
    private SslProvider sslProvider = SslProvider.JDK;
    private URI sslTruststore;
    private String sslTruststorePassword;
    private URI sslKeystore;
    private String sslKeystorePassword;

    public RedisClientConfig() {
    }

    RedisClientConfig(RedisClientConfig config) {
        this.addr = config.addr;
        this.address = config.address;
        this.timer = config.timer;
        this.executor = config.executor;
        this.group = config.group;
        this.socketChannelClass = config.socketChannelClass;
        this.connectTimeout = config.connectTimeout;
        this.commandTimeout = config.commandTimeout;
        this.password = config.password;
        this.database = config.database;
        this.clientName = config.clientName;
        this.readOnly = config.readOnly;
        this.keepPubSubOrder = config.keepPubSubOrder;
        this.pingConnectionInterval = config.pingConnectionInterval;
        this.keepAlive = config.keepAlive;
        this.tcpNoDelay = config.tcpNoDelay;
        this.sslEnableEndpointIdentification = config.sslEnableEndpointIdentification;
        this.sslProvider = config.sslProvider;
        this.sslTruststore = config.sslTruststore;
        this.sslTruststorePassword = config.sslTruststorePassword;
        this.sslKeystore = config.sslKeystore;
        this.sslKeystorePassword = config.sslKeystorePassword;
        this.resolverGroup = config.resolverGroup;
        this.sslHostname = config.sslHostname;
    }

    public String getSslHostname() {
        return this.sslHostname;
    }

    public RedisClientConfig setSslHostname(String sslHostname) {
        this.sslHostname = sslHostname;
        return this;
    }

    public RedisClientConfig setAddress(String host, int port) {
        this.address = URIBuilder.create("redis://" + host + ":" + port);
        return this;
    }

    public RedisClientConfig setAddress(String address) {
        this.address = URIBuilder.create(address);
        return this;
    }

    public RedisClientConfig setAddress(InetSocketAddress addr, URI address) {
        this.addr = addr;
        this.address = address;
        return this;
    }

    public RedisClientConfig setAddress(URI address) {
        this.address = address;
        return this;
    }

    public URI getAddress() {
        return this.address;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public RedisClientConfig setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public RedisClientConfig setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public RedisClientConfig setGroup(EventLoopGroup group) {
        this.group = group;
        return this;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public RedisClientConfig setSocketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public RedisClientConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public RedisClientConfig setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public RedisClientConfig setSslProvider(SslProvider sslMode) {
        this.sslProvider = sslMode;
        return this;
    }

    public URI getSslTruststore() {
        return this.sslTruststore;
    }

    public RedisClientConfig setSslTruststore(URI sslTruststore) {
        this.sslTruststore = sslTruststore;
        return this;
    }

    public URI getSslKeystore() {
        return this.sslKeystore;
    }

    public RedisClientConfig setSslKeystore(URI sslKeystore) {
        this.sslKeystore = sslKeystore;
        return this;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public RedisClientConfig setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
        return this;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public RedisClientConfig setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return this;
    }

    public boolean isSslEnableEndpointIdentification() {
        return this.sslEnableEndpointIdentification;
    }

    public RedisClientConfig setSslEnableEndpointIdentification(boolean enableEndpointIdentification) {
        this.sslEnableEndpointIdentification = enableEndpointIdentification;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RedisClientConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }

    public RedisClientConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public RedisClientConfig setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RedisClientConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isKeepPubSubOrder() {
        return this.keepPubSubOrder;
    }

    public RedisClientConfig setKeepPubSubOrder(boolean keepPubSubOrder) {
        this.keepPubSubOrder = keepPubSubOrder;
        return this;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public RedisClientConfig setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public RedisClientConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public RedisClientConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public DnsAddressResolverGroup getResolverGroup() {
        return this.resolverGroup;
    }

    public RedisClientConfig setResolverGroup(DnsAddressResolverGroup resolverGroup) {
        this.resolverGroup = resolverGroup;
        return this;
    }
}

