/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import org.redisson.executor.CronExpression;

public final class CronSchedule {
    private CronExpression expression;

    CronSchedule(CronExpression expression) {
        this.expression = expression;
    }

    public static CronSchedule of(String expression) {
        return new CronSchedule(new CronExpression(expression));
    }

    public static CronSchedule dailyAtHourAndMinute(int hour, int minute) {
        String expression = String.format("0 %d %d ? * *", minute, hour);
        return CronSchedule.of(expression);
    }

    public static CronSchedule weeklyOnDayAndHourAndMinute(int hour, int minute, Integer ... daysOfWeek) {
        if (daysOfWeek == null || daysOfWeek.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        String expression = String.format("0 %d %d ? * %d", minute, hour, daysOfWeek[0]);
        for (int i = 1; i < daysOfWeek.length; ++i) {
            expression = expression + "," + daysOfWeek[i];
        }
        return CronSchedule.of(expression);
    }

    public static CronSchedule monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute) {
        String expression = String.format("0 %d %d %d * ?", minute, hour, dayOfMonth);
        return CronSchedule.of(expression);
    }

    public CronExpression getExpression() {
        return this.expression;
    }
}

