/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSetCache;
import org.redisson.ScanIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RSetCacheAsync;
import org.redisson.api.RSetCacheReactive;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetCacheReactive<V>
extends RedissonExpirableReactive
implements RSetCacheReactive<V> {
    private final RSetCacheAsync<V> instance;

    public RedissonSetCacheReactive(EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor, name, new RedissonSetCache(evictionScheduler, commandExecutor, name, null));
    }

    public RedissonSetCacheReactive(CommandReactiveExecutor commandExecutor, String name, RSetCacheAsync<V> instance) {
        super(commandExecutor, name, instance);
        this.instance = instance;
    }

    public RedissonSetCacheReactive(Codec codec, EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name) {
        this(codec, commandExecutor, name, new RedissonSetCache(codec, evictionScheduler, commandExecutor, name, null));
    }

    public RedissonSetCacheReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, RSetCacheAsync<V> instance) {
        super(codec, commandExecutor, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetCacheReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> contains(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.containsAsync(o);
            }
        });
    }

    Publisher<ListScanResult<ScanObjectEntry>> scanIterator(final RedisClient client, final long startPos) {
        return this.reactive(new Supplier<RFuture<ListScanResult<ScanObjectEntry>>>(){

            @Override
            public RFuture<ListScanResult<ScanObjectEntry>> get() {
                return ((ScanIterator)((Object)RedissonSetCacheReactive.this.instance)).scanIteratorAsync(RedissonSetCacheReactive.this.getName(), client, startPos, null);
            }
        });
    }

    @Override
    public Publisher<V> iterator() {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient client, long nextIterPos) {
                return RedissonSetCacheReactive.this.scanIterator(client, nextIterPos);
            }
        });
    }

    @Override
    public Publisher<Boolean> add(final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.addAsync(value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<Integer> add(V value) {
        long timeoutDate = 92233720368547758L;
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; ", Arrays.asList(this.getName()), System.currentTimeMillis(), timeoutDate, this.encode(value));
    }

    @Override
    public Publisher<Set<V>> readAll() {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetCacheReactive.this.instance.readAllAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.removeAsync(o);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.containsAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceeded(0);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getName());
        for (V value : c) {
            ByteBuf objectState = this.encode(value);
            params.add(score);
            params.add(objectState);
        }
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZADD_RAW, params.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.retainAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> removeAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetCacheReactive.this.instance.removeAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this).addAll(c);
    }
}

