/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AsyncSemaphore {
    private int counter;
    private final Set<Runnable> listeners = new LinkedHashSet<Runnable>();

    public AsyncSemaphore(int permits) {
        this.counter = permits;
    }

    public boolean tryAcquire(long timeoutMillis) {
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable listener = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.acquire(listener);
        try {
            boolean res = latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!res && !this.remove(listener)) {
                this.release();
            }
            return res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.remove(listener)) {
                this.release();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueSize() {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners() {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Runnable listener) {
        boolean run = false;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            if (this.counter == 0) {
                this.listeners.add(listener);
                return;
            }
            if (this.counter > 0) {
                --this.counter;
                run = true;
            }
        }
        if (run) {
            listener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable listener) {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            return this.listeners.remove(listener);
        }
    }

    public int getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Runnable runnable = null;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            ++this.counter;
            Iterator<Runnable> iter = this.listeners.iterator();
            if (iter.hasNext()) {
                runnable = iter.next();
                iter.remove();
            }
        }
        if (runnable != null) {
            this.acquire(runnable);
        }
    }

    public String toString() {
        return String.valueOf(this.counter);
    }
}

