/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLock;
import org.redisson.ScanIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.Hash;
import org.redisson.misc.RedissonPromise;

public class RedissonSet<V>
extends RedissonExpirable
implements RSet<V>,
ScanIterator {
    RedissonClient redisson;

    public RedissonSet(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.redisson = redisson;
    }

    public RedissonSet(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor.getConnectionManager());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SCARD_INT, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.readAsync(this.getName(o), this.codec, RedisCommands.SISMEMBER, this.getName(o), this.encode(o));
    }

    @Override
    public ListScanResult<ScanObjectEntry> scanIterator(String name, RedisClient client, long startPos, String pattern) {
        if (pattern == null) {
            RFuture f = this.commandExecutor.readAsync(client, name, (Codec)new ScanCodec(this.codec), RedisCommands.SSCAN, name, startPos);
            return (ListScanResult)this.get(f);
        }
        RFuture f = this.commandExecutor.readAsync(client, name, (Codec)new ScanCodec(this.codec), RedisCommands.SSCAN, name, startPos, "MATCH", pattern);
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator(final String pattern) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ListScanResult<ScanObjectEntry> iterator(RedisClient client, long nextIterPos) {
                return RedissonSet.this.scanIterator(RedissonSet.this.getName(), client, nextIterPos, pattern);
            }

            @Override
            protected void remove(ScanObjectEntry value) {
                RedissonSet.this.remove(value.getObj());
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SMEMBERS, this.getName());
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(e), this.codec, RedisCommands.SADD_SINGLE, this.getName(e), this.encode(e));
    }

    @Override
    public V removeRandom() {
        return this.get(this.removeRandomAsync());
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP_SINGLE, this.getName());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        return this.get(this.removeRandomAsync(amount));
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP, this.getName(), amount);
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getName());
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.writeAsync(this.getName(o), this.codec, RedisCommands.SREM_SINGLE, this.getName(o), this.encode(o));
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        return this.commandExecutor.writeAsync(this.getName(member), this.codec, RedisCommands.SMOVE, this.getName(member), destination, this.encode(member));
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(true);
        }
        String tempName = RedissonSet.suffixName(this.getName(), "redisson_temp");
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('sadd', KEYS[2], unpack(ARGV)); local size = redis.call('sdiff', KEYS[2], KEYS[1]);redis.call('del', KEYS[2]); return #size == 0 and 1 or 0; ", Arrays.asList(this.getName(), tempName), this.encode(c).toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        String tempName = RedissonSet.suffixName(this.getName(), "redisson_temp");
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('sadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('scard', KEYS[1]); local size = redis.call('sinterstore', KEYS[1], KEYS[1], KEYS[2]);redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getName(), tempName), this.encode(c).toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SREM_SINGLE, args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTER, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), order});
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "LIMIT", offset, count, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "BY", byPattern, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "BY", byPattern, "LIMIT", offset, count, order});
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, params.toArray());
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        params.add("STORE");
        params.add(destName);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SORT_TO, params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockName(Object value) {
        ByteBuf state = this.encode(value);
        try {
            String string = RedissonSet.suffixName(this.getName(value), Hash.hash128toBase64(state) + ":lock");
            return string;
        }
        finally {
            state.release();
        }
    }

    @Override
    public RLock getLock(V value) {
        String lockName = this.getLockName(value);
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RFuture<ListScanResult<ScanObjectEntry>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern) {
        throw new UnsupportedOperationException();
    }
}

