/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.map;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.transaction.operation.map.MapOperation;

public class MapCachePutOperation
extends MapOperation {
    private long ttlTimeout;
    private TimeUnit ttlUnit;
    private long maxIdleTimeout;
    private TimeUnit maxIdleUnit;

    public MapCachePutOperation() {
    }

    public MapCachePutOperation(RMap<?, ?> map, Object key, Object value, long ttlTimeout, TimeUnit ttlUnit, long maxIdleTimeout, TimeUnit maxIdleUnit) {
        super(map, key, value);
        this.ttlTimeout = ttlTimeout;
        this.ttlUnit = ttlUnit;
        this.maxIdleTimeout = maxIdleTimeout;
        this.maxIdleUnit = maxIdleUnit;
    }

    @Override
    public void commit(RMap<Object, Object> map) {
        ((RMapCache)map).putAsync(this.key, this.value, this.ttlTimeout, this.ttlUnit, this.maxIdleTimeout, this.maxIdleUnit);
    }

    public long getTTL() {
        return this.ttlTimeout;
    }

    public TimeUnit getTTLUnit() {
        return this.ttlUnit;
    }

    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    public TimeUnit getMaxIdleUnit() {
        return this.maxIdleUnit;
    }
}

