/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.RTransaction;
import org.redisson.api.RTransactionReactive;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonBucketReactive;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetReactive;
import org.redisson.transaction.RedissonTransaction;

public class RedissonTransactionReactive
implements RTransactionReactive {
    private final RTransaction transaction;
    private final CommandReactiveExecutor executorService;

    public RedissonTransactionReactive(CommandReactiveExecutor executorService, TransactionOptions options) {
        this.transaction = new RedissonTransaction(executorService, options);
        this.executorService = executorService;
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name) {
        return new RedissonBucketReactive(this.executorService, name, this.transaction.getBucket(name));
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name, Codec codec) {
        return new RedissonBucketReactive(codec, this.executorService, name, this.transaction.getBucket(name, codec));
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name) {
        return new RedissonMapReactive(this.executorService, name, null, this.transaction.getMap(name));
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec) {
        return new RedissonMapReactive(codec, this.executorService, name, null, this.transaction.getMap(name, codec));
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec) {
        return new RedissonMapCacheReactive(codec, this.executorService, name, null, this.transaction.getMapCache(name, codec));
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name) {
        return new RedissonMapCacheReactive(this.executorService, name, null, this.transaction.getMapCache(name));
    }

    @Override
    public <V> RSetReactive<V> getSet(String name) {
        return new RedissonSetReactive(this.executorService, name, this.transaction.getSet(name));
    }

    @Override
    public <V> RSetReactive<V> getSet(String name, Codec codec) {
        return new RedissonSetReactive(codec, this.executorService, name, this.transaction.getSet(name, codec));
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name) {
        return new RedissonSetCacheReactive(this.executorService, name, this.transaction.getSetCache(name));
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name, Codec codec) {
        return new RedissonSetCacheReactive(codec, this.executorService, name, this.transaction.getSetCache(name, codec));
    }

    @Override
    public Publisher<Void> commit() {
        return this.executorService.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonTransactionReactive.this.transaction.commitAsync();
            }
        });
    }

    @Override
    public Publisher<Void> rollback() {
        return this.executorService.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonTransactionReactive.this.transaction.rollbackAsync();
            }
        });
    }
}

