/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxHandleFuseable<T, R>
extends FluxOperator<T, R>
implements Fuseable {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    FluxHandleFuseable(Flux<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new HandleFuseableConditionalSubscriber<T, R>(cs, this.handler));
            return;
        }
        this.source.subscribe(new HandleFuseableSubscriber<T, R>(actual, this.handler));
    }

    static final class HandleFuseableConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, R>,
    Fuseable.QueueSubscription<R>,
    SynchronousSink<R> {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        HandleFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                R v = this.data;
                this.data = null;
                if (v != null) {
                    this.actual.onNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(Operators.onOperatorError(null, this.error, v, this.actual.currentContext()));
                        return;
                    }
                    this.actual.onComplete();
                } else if (v == null) {
                    this.s.request(1L);
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return false;
            }
            R v = this.data;
            this.data = null;
            boolean emit = false;
            if (v != null) {
                emit = this.actual.tryOnNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(Operators.onOperatorError(null, this.error, v, this.actual.currentContext()));
                } else {
                    this.actual.onComplete();
                }
                return true;
            }
            return emit;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Objects.requireNonNull(e, "error");
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public R poll() {
            Object v;
            if (this.sourceMode == 2) {
                if (this.done) {
                    return null;
                }
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) != null) {
                        this.handler.accept(v2, this);
                        R u = this.data;
                        this.data = null;
                        if (this.done) {
                            this.s.cancel();
                            if (this.error != null) {
                                throw Exceptions.propagate(Operators.onOperatorError(null, this.error, v2, this.actual.currentContext()));
                            }
                            this.actual.onComplete();
                            return u;
                        }
                        if (u != null) {
                            return u;
                        }
                        ++dropped;
                        continue;
                    }
                    if (dropped == 0L) break;
                    this.request(dropped);
                    dropped = 0L;
                }
                return null;
            }
            while ((v = this.s.poll()) != null) {
                this.handler.accept(v, this);
                R u = this.data;
                this.data = null;
                if (this.done) {
                    if (this.error != null) {
                        throw Exceptions.propagate(Operators.onOperatorError(null, this.error, v, this.actual.currentContext()));
                    }
                    return u;
                }
                if (u == null) continue;
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class HandleFuseableSubscriber<T, R>
    implements InnerOperator<T, R>,
    Fuseable.ConditionalSubscriber<T>,
    Fuseable.QueueSubscription<R>,
    SynchronousSink<R> {
        final CoreSubscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        HandleFuseableSubscriber(CoreSubscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return false;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.done) {
                if (this.error != null) {
                    this.actual.onError(Operators.onOperatorError(this.s, this.error, t, this.actual.currentContext()));
                } else {
                    this.s.cancel();
                    this.actual.onComplete();
                }
                return true;
            }
            return v != null;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    this.handler.accept(t, this);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                R v = this.data;
                this.data = null;
                if (v != null) {
                    this.actual.onNext(v);
                }
                if (this.done) {
                    this.s.cancel();
                    if (this.error != null) {
                        this.actual.onError(Operators.onOperatorError(null, this.error, t, this.actual.currentContext()));
                        return;
                    }
                    this.actual.onComplete();
                } else if (v == null) {
                    this.s.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public R poll() {
            Object v;
            if (this.sourceMode == 2) {
                if (this.done) {
                    return null;
                }
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) != null) {
                        this.handler.accept(v2, this);
                        R u = this.data;
                        this.data = null;
                        if (this.done) {
                            this.s.cancel();
                            if (this.error != null) {
                                throw Exceptions.propagate(Operators.onOperatorError(null, this.error, v2, this.actual.currentContext()));
                            }
                            this.actual.onComplete();
                            return u;
                        }
                        if (u != null) {
                            return u;
                        }
                        ++dropped;
                        continue;
                    }
                    if (dropped == 0L) break;
                    this.request(dropped);
                    dropped = 0L;
                }
                return null;
            }
            while ((v = this.s.poll()) != null) {
                this.handler.accept(v, this);
                R u = this.data;
                this.data = null;
                if (this.done) {
                    if (this.error != null) {
                        throw Exceptions.propagate(Operators.onOperatorError(null, this.error, v, this.actual.currentContext()));
                    }
                    return u;
                }
                if (u == null) continue;
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Objects.requireNonNull(e, "error");
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }
    }
}

