/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonReference;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonObjectFactory;

public abstract class RedissonObject
implements RObject {
    protected final CommandAsyncExecutor commandExecutor;
    private final String name;
    protected final Codec codec;

    public RedissonObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    public RedissonObject(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected boolean await(RFuture<?> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        return this.commandExecutor.await(future, timeout, timeoutUnit);
    }

    protected static String prefixName(String prefix, String name) {
        if (name.contains("{")) {
            return prefix + ":" + name;
        }
        return prefix + ":{" + name + "}";
    }

    protected static String suffixName(String name, String suffix) {
        if (name.contains("{")) {
            return name + ":" + suffix;
        }
        return "{" + name + "}:" + suffix;
    }

    protected <V> V get(RFuture<V> future) {
        return this.commandExecutor.get(future);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getName(Object o) {
        return this.getName();
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAME, this.getName(), newName);
    }

    @Override
    public void migrate(String host, int port, int database) {
        this.get(this.migrateAsync(host, port, database));
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MIGRATE, host, port, this.getName(), database);
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAMENX, this.getName(), newName);
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_BOOL, this.getName());
    }

    @Override
    public boolean unlink() {
        return this.get(this.unlinkAsync());
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.UNLINK_BOOL, this.getName());
    }

    @Override
    public boolean touch() {
        return this.get(this.touchAsync());
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.TOUCH, this.getName());
    }

    @Override
    public boolean isExists() {
        return this.get(this.isExistsAsync());
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected List<ByteBuf> encode(Collection<?> values) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(values.size());
        for (Object object : values) {
            result.add(this.encode(object));
        }
        return result;
    }

    protected void encode(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encode(object));
        }
    }

    protected void encodeMapKeys(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encodeMapKey(object));
        }
    }

    protected void encodeMapValues(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encodeMapValue(object));
        }
    }

    protected ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapKey(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapKeyEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapValue(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

