/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.redisson.QueueTransferService;
import org.redisson.QueueTransferTask;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonTopic;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonDelayedQueue<V>
extends RedissonExpirable
implements RDelayedQueue<V> {
    private final QueueTransferService queueTransferService;

    protected RedissonDelayedQueue(QueueTransferService queueTransferService, Codec codec, final CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        QueueTransferTask task = new QueueTransferTask(commandExecutor.getConnectionManager()){

            @Override
            protected RFuture<Long> pushTaskAsync() {
                return commandExecutor.evalWriteAsync(RedissonDelayedQueue.this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local expiredValues = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredValues > 0 then for i, v in ipairs(expiredValues) do local randomId, value = struct.unpack('dLc0', v);redis.call('rpush', KEYS[1], value);redis.call('lrem', KEYS[3], 1, v);end; redis.call('zrem', KEYS[2], unpack(expiredValues));end; local v = redis.call('zrange', KEYS[2], 0, 0, 'WITHSCORES'); if v[1] ~= nil then return v[2]; end return nil;", Arrays.asList(RedissonDelayedQueue.this.getName(), RedissonDelayedQueue.this.getTimeoutSetName(), RedissonDelayedQueue.this.getQueueName()), System.currentTimeMillis(), 100);
            }

            @Override
            protected RTopic<Long> getTopic() {
                return new RedissonTopic<Long>(LongCodec.INSTANCE, commandExecutor, RedissonDelayedQueue.this.getChannelName());
            }
        };
        queueTransferService.schedule(this.getQueueName(), task);
        this.queueTransferService = queueTransferService;
    }

    private String getChannelName() {
        return RedissonDelayedQueue.prefixName("redisson_delay_queue_channel", this.getName());
    }

    private String getQueueName() {
        return RedissonDelayedQueue.prefixName("redisson_delay_queue", this.getName());
    }

    private String getTimeoutSetName() {
        return RedissonDelayedQueue.prefixName("redisson_delay_queue_timeout", this.getName());
    }

    @Override
    public void offer(V e, long delay, TimeUnit timeUnit) {
        this.get(this.offerAsync(e, delay, timeUnit));
    }

    @Override
    public RFuture<Void> offerAsync(V e, long delay, TimeUnit timeUnit) {
        long delayInMs = timeUnit.toMillis(delay);
        long timeout = System.currentTimeMillis() + delayInMs;
        long randomId = PlatformDependent.threadLocalRandom().nextLong();
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "local value = struct.pack('dLc0', tonumber(ARGV[2]), string.len(ARGV[3]), ARGV[3]);redis.call('zadd', KEYS[2], ARGV[1], value);redis.call('rpush', KEYS[3], value);local v = redis.call('zrange', KEYS[2], 0, 0); if v[1] == value then redis.call('publish', KEYS[4], ARGV[1]); end;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getQueueName(), this.getChannelName()), timeout, randomId, this.encode(e));
    }

    @Override
    public boolean add(V e) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public boolean offer(V e) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public V remove() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        V value = this.peek();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V peek() {
        return this.get(this.peekAsync());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    V getValue(int index) {
        return (V)this.get(this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); if v ~= false then local randomId, value = struct.unpack('dLc0', v);return value; end return nil;", Arrays.asList(this.getQueueName()), index));
    }

    void remove(int index) {
        this.get(this.commandExecutor.evalWriteAsync(this.getName(), null, RedisCommands.EVAL_VOID, "local v = redis.call('lindex', KEYS[1], ARGV[1]);if v ~= false then local randomId, value = struct.unpack('dLc0', v);redis.call('lrem', KEYS[1], 1, v);redis.call('zrem', KEYS[2], v);end; ", Arrays.asList(this.getQueueName(), this.getTimeoutSetName()), index));
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private V nextCurrentValue;
            private V currentValueHasRead;
            private int currentIndex = -1;
            private boolean hasBeenModified = true;

            @Override
            public boolean hasNext() {
                Object val = RedissonDelayedQueue.this.getValue(this.currentIndex + 1);
                if (val != null) {
                    this.nextCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V next() {
                if (this.nextCurrentValue == null && !this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.currentValueHasRead = this.nextCurrentValue;
                this.nextCurrentValue = null;
                this.hasBeenModified = false;
                return this.currentValueHasRead;
            }

            @Override
            public void remove() {
                if (this.currentValueHasRead == null) {
                    throw new IllegalStateException("Neither next nor previous have been called");
                }
                if (this.hasBeenModified) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonDelayedQueue.this.remove(this.currentIndex);
                --this.currentIndex;
                this.hasBeenModified = true;
                this.currentValueHasRead = null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local result = {}; local items = redis.call('lrange', KEYS[1], 0, -1); for i, v in ipairs(items) do local randomId, value = struct.unpack('dLc0', v); table.insert(result, value);end; return result; ", Collections.singletonList(this.getQueueName()), new Object[0]);
    }

    @Override
    public boolean remove(Object o) {
        return this.get(this.removeAsync(o));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    protected RFuture<Boolean> removeAsync(Object o, int count) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('llen', KEYS[1]);for i = 0, s-1, 1 do local v = redis.call('lindex', KEYS[1], i);local randomId, value = struct.unpack('dLc0', v);if ARGV[1] == value then redis.call('zrem', KEYS[2], v);redis.call('lrem', KEYS[1], 1, v);return 1;end; end;return 0;", Arrays.asList(this.getQueueName(), this.getTimeoutSetName()), this.encode(o));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(true);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('llen', KEYS[1]);for i = 0, s-1, 1 do local v = redis.call('lindex', KEYS[1], i);local randomId, value = struct.unpack('dLc0', v);for j = 1, #ARGV, 1 do if value == ARGV[j] then table.remove(ARGV, j) end; end; end;return #ARGV == 0 and 1 or 0;", Collections.singletonList(this.getQueueName()), this.encode(c).toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local result = 0;local s = redis.call('llen', KEYS[1]);local i = 0;while i < s do local v = redis.call('lindex', KEYS[1], i);local randomId, value = struct.unpack('dLc0', v);for j = 1, #ARGV, 1 do if value == ARGV[j] then result = 1; i = i - 1; s = s - 1; redis.call('zrem', KEYS[2], v);redis.call('lrem', KEYS[1], 0, v); break; end; end; i = i + 1;end; return result;", Arrays.asList(this.getQueueName(), this.getTimeoutSetName()), this.encode(c).toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local changed = 0; local items = redis.call('lrange', KEYS[1], 0, -1); local i = 1; while i <= #items do local randomId, element = struct.unpack('dLc0', items[i]); local isInAgrs = false; for j = 1, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true; break; end; end; if isInAgrs == false then redis.call('LREM', KEYS[1], 0, items[i]) changed = 1; end; i = i + 1; end; return changed; ", Collections.singletonList(this.getQueueName()), this.encode(c).toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getQueueName(), this.getTimeoutSetName());
    }

    @Override
    public RFuture<V> peekAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], 0); if v ~= false then local randomId, value = struct.unpack('dLc0', v);return value; end return nil;", Arrays.asList(this.getQueueName()), new Object[0]);
    }

    @Override
    public RFuture<V> pollAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lpop', KEYS[1]); if v ~= false then redis.call('zrem', KEYS[2], v); local randomId, value = struct.unpack('dLc0', v);return value; end return nil;", Arrays.asList(this.getQueueName(), this.getTimeoutSetName()), new Object[0]);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('rpop', KEYS[1]); if v ~= false then redis.call('zrem', KEYS[2], v); local randomId, value = struct.unpack('dLc0', v);redis.call('lpush', KEYS[3], value); return value; end return nil;", Arrays.asList(this.getQueueName(), this.getTimeoutSetName(), queueName), new Object[0]);
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('llen', KEYS[1]);for i = 0, s-1, 1 do local v = redis.call('lindex', KEYS[1], i);local randomId, value = struct.unpack('dLc0', v);if ARGV[1] == value then return 1;end; end;return 0;", Collections.singletonList(this.getQueueName()), this.encode(o));
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.LLEN_INT, this.getQueueName());
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        throw new UnsupportedOperationException("Use 'offer' method with timeout param");
    }

    @Override
    public V pollLastAndOfferFirstTo(String dequeName) {
        return this.get(this.pollLastAndOfferFirstToAsync(dequeName));
    }

    @Override
    public void destroy() {
        this.queueTransferService.remove(this.getQueueName());
    }
}

