/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.ClusterNodesDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.cluster.ClusterNodeInfo;
import org.redisson.cluster.ClusterPartition;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.CRC16;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Integer, ClusterPartition> lastPartitions = new ConcurrentHashMap<Integer, ClusterPartition>();
    private final Map<RedisURI, ClusterPartition> lastUri2Partition = new ConcurrentHashMap<RedisURI, ClusterPartition>();
    private volatile Timeout monitorFuture;
    private volatile RedisURI lastClusterNode;
    private RedisStrictCommand<List<ClusterNodeInfo>> clusterNodesCommand;
    private String configEndpointHostName;
    private String configEndpointPassword;
    private final AtomicReferenceArray<MasterSlaveEntry> slot2entry = new AtomicReferenceArray(16384);
    private final Map<RedisClient, MasterSlaveEntry> client2entry = new ConcurrentHashMap<RedisClient, MasterSlaveEntry>();
    private ClusterServersConfig cfg;

    ClusterConnectionManager(ClusterServersConfig cfg, Config configCopy) {
        super(cfg, configCopy);
        this.serviceManager.setNatMapper(cfg.getNatMapper());
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        this.cfg = (ClusterServersConfig)cfg;
        return super.create(cfg);
    }

    @Override
    public void doConnect(Function<RedisURI, String> hostnameMapper) {
        if (this.cfg.getScanInterval() <= 0) {
            throw new IllegalArgumentException("scanInterval setting can't be 0 or less");
        }
        if (this.cfg.getNodeAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one cluster node should be defined!");
        }
        Throwable lastException = null;
        ArrayList<String> failedMasters = new ArrayList<String>();
        boolean skipCommandsDetection = false;
        for (String address : this.cfg.getNodeAddresses()) {
            RedisURI addr = new RedisURI(address);
            CompletionStage<RedisConnection> connectionFuture = this.connectToNode(this.cfg, addr, addr.getHost());
            try {
                Collection<ClusterPartition> partitions;
                RedisConnection connection = connectionFuture.toCompletableFuture().get(this.config.getConnectTimeout(), TimeUnit.MILLISECONDS);
                if (this.cfg.getNodeAddresses().size() == 1 && !addr.isIP()) {
                    this.configEndpointHostName = addr.getHost();
                    this.configEndpointPassword = addr.getPassword();
                }
                this.clusterNodesCommand = new RedisStrictCommand<Object>("CLUSTER", "NODES", new ObjectDecoder<List<ClusterNodeInfo>>(new ClusterNodesDecoder(addr.getScheme())));
                if (!skipCommandsDetection) {
                    this.subscribeService.checkShardingSupport(this.cfg.getShardedSubscriptionMode(), connection);
                    this.subscribeService.checkPatternSupport(connection);
                    skipCommandsDetection = true;
                }
                List<ClusterNodeInfo> nodes = connection.sync(this.clusterNodesCommand, new Object[0]);
                StringBuilder nodesValue = new StringBuilder();
                for (ClusterNodeInfo clusterNodeInfo : nodes) {
                    nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                }
                this.log.info("Redis cluster nodes configuration got from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
                this.lastClusterNode = addr;
                CompletableFuture<Collection<ClusterPartition>> partitionsFuture = this.parsePartitions(nodes);
                try {
                    partitions = partitionsFuture.join();
                }
                catch (CompletionException e) {
                    lastException = e.getCause();
                    break;
                }
                ArrayList<CompletableFuture<Void>> masterFutures = new ArrayList<CompletableFuture<Void>>();
                for (ClusterPartition partition : partitions) {
                    if (partition.isMasterFail()) {
                        failedMasters.add(partition.getMasterAddress().toString());
                        continue;
                    }
                    if (partition.getMasterAddress() == null) {
                        throw new IllegalStateException("Master node: " + partition.getNodeId() + " doesn't have an address.");
                    }
                    CompletionStage<Void> masterFuture = this.addMasterEntry(partition, this.cfg);
                    masterFutures.add(masterFuture.toCompletableFuture());
                }
                CompletableFuture<Void> masterFuture = CompletableFuture.allOf(masterFutures.toArray(new CompletableFuture[0]));
                try {
                    masterFuture.join();
                }
                catch (CompletionException e) {
                    lastException = e.getCause();
                }
                break;
            }
            catch (Exception e) {
                if (e instanceof CompletionException) {
                    e = (Exception)e.getCause();
                }
                lastException = e;
                if (e instanceof TimeoutException) {
                    this.log.warn("Connection timeout to {}", (Object)address);
                }
                if (e.getMessage() == null) continue;
                this.log.warn(e.getMessage());
            }
        }
        if (this.lastPartitions.isEmpty()) {
            this.internalShutdown();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Can't connect to servers!", lastException);
            }
            throw new RedisConnectionException("Can't connect to servers! Failed masters according to cluster status: " + failedMasters, lastException);
        }
        if (this.cfg.isCheckSlotsCoverage() && this.lastPartitions.size() != 16384) {
            this.internalShutdown();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Not all slots covered! Only " + this.lastPartitions.size() + " slots are available. Set checkSlotsCoverage = false to avoid this check.", lastException);
            }
            throw new RedisConnectionException("Not all slots covered! Only " + this.lastPartitions.size() + " slots are available. Set checkSlotsCoverage = false to avoid this check. Failed masters according to cluster status: " + failedMasters, lastException);
        }
        this.scheduleClusterChangeCheck(this.cfg);
    }

    @Override
    public Collection<MasterSlaveEntry> getEntrySet() {
        this.lazyConnect();
        return this.client2entry.values();
    }

    @Override
    public MasterSlaveEntry getEntry(RedisURI addr) {
        this.lazyConnect();
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            if (addr.equals(entry.getClient().getAddr())) {
                return entry;
            }
            if (!entry.hasSlave(addr)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisClient redisClient) {
        this.lazyConnect();
        MasterSlaveEntry entry = this.client2entry.get(redisClient);
        if (entry != null) {
            return entry;
        }
        for (MasterSlaveEntry mentry : this.client2entry.values()) {
            if (!mentry.hasSlave(redisClient)) continue;
            return mentry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(InetSocketAddress address) {
        this.lazyConnect();
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            InetSocketAddress addr = entry.getClient().getAddr();
            if (addr.getAddress().equals(address.getAddress()) && addr.getPort() == address.getPort()) {
                return entry;
            }
            if (!entry.hasSlave(address)) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected CompletableFuture<RedisClient> changeMaster(int slot, RedisURI address) {
        MasterSlaveEntry entry = this.getEntry(slot);
        RedisClient oldClient = entry.getClient();
        CompletableFuture<RedisClient> future = super.changeMaster(slot, address);
        return future.thenApply(res -> {
            this.client2entry.remove(oldClient);
            this.client2entry.put(entry.getClient(), entry);
            return res;
        });
    }

    @Override
    public MasterSlaveEntry getEntry(int slot) {
        this.lazyConnect();
        return this.slot2entry.get(slot);
    }

    private void addEntry(Integer slot, MasterSlaveEntry entry) {
        MasterSlaveEntry oldEntry = this.slot2entry.getAndSet(slot, entry);
        if (oldEntry != entry) {
            entry.incReference();
            this.shutdownEntry(oldEntry, entry);
        }
        this.client2entry.put(entry.getClient(), entry);
    }

    private void removeEntry(Integer slot) {
        MasterSlaveEntry entry = this.slot2entry.getAndSet(slot, null);
        this.shutdownEntry(entry, null);
    }

    private void removeEntry(Integer slot, MasterSlaveEntry entry) {
        if (this.slot2entry.compareAndSet(slot, entry, null)) {
            this.shutdownEntry(entry, null);
        }
    }

    private void shutdownEntry(MasterSlaveEntry entry, MasterSlaveEntry newEntry) {
        if (entry != null && entry.decReference() == 0) {
            entry.getAllEntries().forEach(e -> {
                RedisURI uri = new RedisURI(e.getClient().getConfig().getAddress().getScheme(), e.getClient().getAddr().getAddress().getHostAddress(), e.getClient().getAddr().getPort());
                this.disconnectNode(uri);
                e.nodeDown();
            });
            entry.masterDown();
            entry.shutdownAsync();
            entry.setReplacedBy(newEntry);
            this.subscribeService.remove(entry);
            RedisURI uri = new RedisURI(entry.getClient().getConfig().getAddress().getScheme(), entry.getClient().getAddr().getAddress().getHostAddress(), entry.getClient().getAddr().getPort());
            this.disconnectNode(uri);
            this.client2entry.remove(entry.getClient());
            String slaves = entry.getAllEntries().stream().filter(e -> !e.getClient().getAddr().equals(entry.getClient().getAddr())).map(e -> e.getClient().toString()).collect(Collectors.joining(","));
            this.log.info("{} master and related slaves: {} removed", (Object)entry.getClient().getAddr(), (Object)slaves);
        }
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        result.setReadOnly(type == NodeType.SLAVE && this.config.getReadMode() != ReadMode.MASTER);
        return result;
    }

    private CompletionStage<Void> addMasterEntry(ClusterPartition partition, ClusterServersConfig cfg) {
        if (partition.isMasterFail()) {
            RedisException e = new RedisException("Failed to add master: " + partition.getMasterAddress() + " for slot ranges: " + partition.getSlotRanges() + ". Reason - server has FAIL flag");
            if (partition.getSlotsAmount() == 0) {
                e = new RedisException("Failed to add master: " + partition.getMasterAddress() + ". Reason - server has FAIL flag");
            }
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.completeExceptionally(e);
            return result;
        }
        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(cfg, partition.getMasterAddress(), this.configEndpointHostName);
        return connectionFuture.thenCompose(connection -> {
            MasterSlaveEntry entry;
            MasterSlaveServersConfig config = this.create(cfg);
            config.setMasterAddress(partition.getMasterAddress().toString());
            if (config.isSlaveNotUsed()) {
                entry = new SingleEntry(this, config);
            } else {
                Set<String> slaveAddresses = partition.getSlaveAddresses().stream().filter(r -> !partition.getFailedSlaveAddresses().contains(r)).map(r -> r.toString()).collect(Collectors.toSet());
                config.setSlaveAddresses(slaveAddresses);
                entry = new MasterSlaveEntry(this, config);
            }
            CompletableFuture<RedisClient> f = entry.setupMasterEntry(new RedisURI(config.getMasterAddress()), this.configEndpointHostName);
            return f.thenCompose(masterClient -> {
                for (Integer slot : partition.getSlots()) {
                    this.addEntry(slot, entry);
                    this.addPartition(slot, partition);
                }
                if (partition.getSlotsAmount() > 0) {
                    this.lastUri2Partition.put(partition.getMasterAddress(), partition);
                }
                if (!config.isSlaveNotUsed()) {
                    CompletableFuture<Void> fs = entry.initSlaveBalancer(r -> this.configEndpointHostName);
                    return fs.thenAccept(r -> {
                        if (!partition.getSlaveAddresses().isEmpty()) {
                            this.log.info("slaves: {} added for master: {} slot ranges: {}", partition.getSlaveAddresses(), partition.getMasterAddress(), partition.getSlotRanges());
                            if (!partition.getFailedSlaveAddresses().isEmpty()) {
                                this.log.warn("slaves: {} down for master: {} slot ranges: {}", partition.getFailedSlaveAddresses(), partition.getMasterAddress(), partition.getSlotRanges());
                            }
                        }
                        this.log.info("master: {} added for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                    });
                }
                this.log.info("master: {} added for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    private void addPartition(Integer slot, ClusterPartition partition) {
        partition.incReference();
        ClusterPartition prevPartiton = this.lastPartitions.put(slot, partition);
        if (prevPartiton != null && prevPartiton.decReference() == 0) {
            this.lastUri2Partition.remove(prevPartiton.getMasterAddress());
        }
    }

    private void scheduleClusterChangeCheck(ClusterServersConfig cfg) {
        this.monitorFuture = this.serviceManager.newTimeout(t -> {
            if (this.configEndpointHostName != null) {
                String address = cfg.getNodeAddresses().iterator().next();
                RedisURI uri = new RedisURI(address);
                CompletableFuture<List<RedisURI>> allNodes = this.serviceManager.resolveAll(uri);
                allNodes.whenComplete((nodes, ex) -> {
                    this.log.debug("{} resolved to {}", (Object)uri, nodes);
                    AtomicReference<Throwable> lastException = new AtomicReference<Throwable>((Throwable)ex);
                    if (ex != null) {
                        this.checkClusterState(cfg, Collections.emptyIterator(), lastException, (List<RedisURI>)nodes);
                        return;
                    }
                    Iterator<RedisURI> nodesIterator = nodes.iterator();
                    this.checkClusterState(cfg, nodesIterator, lastException, (List<RedisURI>)nodes);
                });
            } else {
                AtomicReference<Throwable> lastException = new AtomicReference<Throwable>();
                ArrayList<RedisURI> nodes2 = new ArrayList<RedisURI>();
                ArrayList<RedisURI> slaves = new ArrayList<RedisURI>();
                for (ClusterPartition partition : this.getLastPartitions()) {
                    if (!partition.isMasterFail()) {
                        nodes2.add(partition.getMasterAddress());
                    }
                    HashSet<RedisURI> partitionSlaves = new HashSet<RedisURI>(partition.getSlaveAddresses());
                    partitionSlaves.removeAll(partition.getFailedSlaveAddresses());
                    slaves.addAll(partitionSlaves);
                }
                Collections.shuffle(nodes2);
                Collections.shuffle(slaves);
                nodes2.addAll(slaves);
                Iterator<RedisURI> nodesIterator = nodes2.iterator();
                this.checkClusterState(cfg, nodesIterator, lastException, nodes2);
            }
        }, cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkClusterState(ClusterServersConfig cfg, Iterator<RedisURI> iterator, AtomicReference<Throwable> lastException, List<RedisURI> allNodes) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state using nodes: {}. A new attempt will be made.", (Object)allNodes, (Object)lastException.getAndSet(null));
            }
            this.scheduleClusterChangeCheck(cfg);
            return;
        }
        if (this.serviceManager.isShuttingDown()) {
            return;
        }
        RedisURI uri = iterator.next();
        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(cfg, uri, this.configEndpointHostName);
        connectionFuture.whenComplete((connection, e) -> {
            if (e != null) {
                if (!lastException.compareAndSet((Throwable)null, (Throwable)e)) {
                    ((Throwable)lastException.get()).addSuppressed((Throwable)e);
                }
                this.checkClusterState(cfg, iterator, lastException, allNodes);
                return;
            }
            this.updateClusterState(cfg, (RedisConnection)connection, iterator, uri, lastException, allNodes);
        });
    }

    private void updateClusterState(ClusterServersConfig cfg, RedisConnection connection, Iterator<RedisURI> iterator, RedisURI uri, AtomicReference<Throwable> lastException, List<RedisURI> allNodes) {
        RFuture future = connection.async(StringCodec.INSTANCE, this.clusterNodesCommand, new Object[0]);
        future.whenComplete((nodes, e) -> {
            if (e != null) {
                if (!lastException.compareAndSet((Throwable)null, (Throwable)e)) {
                    ((Throwable)lastException.get()).addSuppressed((Throwable)e);
                }
                this.checkClusterState(cfg, iterator, lastException, allNodes);
                return;
            }
            if (nodes.isEmpty()) {
                this.log.debug("cluster nodes state got from {}: doesn't contain any nodes", (Object)connection.getRedisClient().getAddr());
                this.checkClusterState(cfg, iterator, lastException, allNodes);
                return;
            }
            this.lastClusterNode = uri;
            if (this.log.isDebugEnabled()) {
                StringBuilder nodesValue = new StringBuilder();
                for (ClusterNodeInfo clusterNodeInfo : nodes) {
                    nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                }
                this.log.debug("Cluster nodes state got from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
                this.serviceManager.setLastClusterNodes(nodesValue.toString());
            }
            CompletableFuture<Collection<ClusterPartition>> newPartitionsFuture = this.parsePartitions((List<ClusterNodeInfo>)nodes);
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)newPartitionsFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    StringBuilder nodesValue = new StringBuilder();
                    for (ClusterNodeInfo clusterNodeInfo : nodes) {
                        nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                    }
                    this.log.error("Unable to parse cluster nodes state got from: {}:\n{}", connection.getRedisClient().getAddr(), nodesValue, ex);
                    if (!lastException.compareAndSet((Throwable)null, (Throwable)ex)) {
                        ((Throwable)lastException.get()).addSuppressed((Throwable)ex);
                    }
                    this.checkClusterState(cfg, iterator, lastException, allNodes);
                }
            })).thenCompose(newPartitions -> this.checkMasterNodesChange(cfg, (Collection<ClusterPartition>)newPartitions))).thenCompose(r -> newPartitionsFuture)).thenCompose(newPartitions -> this.checkSlaveNodesChange((Collection<ClusterPartition>)newPartitions))).thenCompose(r -> newPartitionsFuture)).whenComplete((newPartitions, ex) -> {
                if (newPartitions != null && !newPartitions.isEmpty()) {
                    try {
                        this.checkSlotsMigration((Collection<ClusterPartition>)newPartitions);
                        this.checkSlotsChange((Collection<ClusterPartition>)newPartitions);
                    }
                    catch (Exception exc) {
                        this.log.error(exc.getMessage(), exc);
                    }
                }
                if (ex != null) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
                this.scheduleClusterChangeCheck(cfg);
            });
        });
    }

    private CompletableFuture<Void> checkSlaveNodesChange(Collection<ClusterPartition> newPartitions) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (ClusterPartition newPart : newPartitions) {
            ClusterPartition currentPart = this.lastUri2Partition.get(newPart.getMasterAddress());
            if (currentPart == null) continue;
            MasterSlaveEntry entry = this.getEntry(currentPart.getSlotRanges().iterator().next().getStartSlot());
            CompletableFuture<Set<RedisURI>> addedSlavesFuture = this.addRemoveSlaves(entry, currentPart, newPart);
            CompletionStage f = addedSlavesFuture.thenCompose(addedSlaves -> this.upDownSlaves(entry, currentPart, newPart, (Set<RedisURI>)addedSlaves));
            futures.add(f);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).exceptionally(e -> {
            if (e != null) {
                this.log.error("Unable to add/remove slave nodes", (Throwable)e);
            }
            return null;
        });
    }

    private CompletableFuture<Void> upDownSlaves(MasterSlaveEntry entry, ClusterPartition currentPart, ClusterPartition newPart, Set<RedisURI> addedSlaves) {
        ArrayList futures = new ArrayList();
        List<RedisURI> nonFailedSlaves = currentPart.getFailedSlaveAddresses().stream().filter(uri -> !addedSlaves.contains(uri) && !newPart.getFailedSlaveAddresses().contains(uri)).collect(Collectors.toList());
        nonFailedSlaves.forEach(uri -> {
            if (entry.hasSlave((RedisURI)uri)) {
                CompletionStage<Boolean> f = entry.slaveUpNoMasterExclusionAsync((RedisURI)uri);
                f = f.thenApply(v -> {
                    if (v.booleanValue()) {
                        this.log.info("slave: {} is up for slot ranges: {}", uri, (Object)currentPart.getSlotRanges());
                        currentPart.removeFailedSlaveAddress((RedisURI)uri);
                        entry.excludeMasterFromSlaves((RedisURI)uri);
                    }
                    return v;
                });
                futures.add(f);
            }
        });
        newPart.getFailedSlaveAddresses().stream().filter(uri -> !currentPart.getFailedSlaveAddresses().contains(uri)).forEach(uri -> {
            currentPart.addFailedSlaveAddress((RedisURI)uri);
            boolean slaveDown = entry.slaveDown((RedisURI)uri);
            if (this.config.isSlaveNotUsed() || slaveDown) {
                this.disconnectNode((RedisURI)uri);
                this.log.warn("slave: {} has down for slot ranges: {}", uri, (Object)currentPart.getSlotRanges());
            }
        });
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<Set<RedisURI>> addRemoveSlaves(MasterSlaveEntry entry, ClusterPartition currentPart, ClusterPartition newPart) {
        HashSet<RedisURI> removedSlaves = new HashSet<RedisURI>(currentPart.getSlaveAddresses());
        removedSlaves.removeAll(newPart.getSlaveAddresses());
        if (!removedSlaves.isEmpty()) {
            this.log.info("removed slaves detected for master {}. current slaves {} last slaves {}", currentPart.getMasterAddress(), currentPart.getSlaveAddresses(), newPart.getSlaveAddresses());
        }
        for (RedisURI uri2 : removedSlaves) {
            currentPart.removeSlaveAddress(uri2);
            boolean slaveDown = entry.slaveDown(uri2);
            if (!this.config.isSlaveNotUsed() && !slaveDown) continue;
            this.disconnectNode(uri2);
            this.log.info("slave {} removed for master {} and slot ranges: {}", currentPart.getMasterAddress(), uri2, currentPart.getSlotRanges());
        }
        Set addedSlaves = newPart.getSlaveAddresses().stream().filter(uri -> !currentPart.getSlaveAddresses().contains(uri) && !newPart.getFailedSlaveAddresses().contains(uri) || currentPart.getSlaveAddresses().contains(uri) && currentPart.getFailedSlaveAddresses().contains(uri) && !newPart.getFailedSlaveAddresses().contains(uri) && !entry.hasSlave((RedisURI)uri)).collect(Collectors.toSet());
        if (!addedSlaves.isEmpty()) {
            this.log.info("added slaves detected for master {}. current slaves {} last slaves {} last failed slaves {}", currentPart.getMasterAddress(), currentPart.getSlaveAddresses(), newPart.getSlaveAddresses(), newPart.getFailedSlaveAddresses());
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (RedisURI uri3 : addedSlaves) {
            CompletionStage<Object> slaveUpFuture;
            ClientConnectionsEntry slaveEntry = entry.getEntry(uri3);
            if (slaveEntry != null) {
                slaveUpFuture = entry.slaveUpNoMasterExclusionAsync(uri3);
                slaveUpFuture = slaveUpFuture.thenApply(v -> {
                    if (v.booleanValue()) {
                        currentPart.addSlaveAddress(uri3);
                        currentPart.removeFailedSlaveAddress(uri3);
                        this.log.info("slave: {} unfreezed for master {} and slot ranges: {}", currentPart.getMasterAddress(), uri3, currentPart.getSlotRanges());
                        entry.excludeMasterFromSlaves(uri3);
                    }
                    return v;
                });
                futures.add(slaveUpFuture);
                continue;
            }
            if (this.config.isSlaveNotUsed()) continue;
            slaveUpFuture = entry.addSlave(uri3, this.configEndpointHostName);
            CompletionStage f = slaveUpFuture.thenAccept(res -> {
                currentPart.addSlaveAddress(uri3);
                currentPart.removeFailedSlaveAddress(uri3);
                this.log.info("slave: {} added for master {} and slot ranges: {}", currentPart.getMasterAddress(), uri3, currentPart.getSlotRanges());
                entry.excludeMasterFromSlaves(uri3);
            });
            futures.add(f);
        }
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return f.thenApply(r -> addedSlaves);
    }

    private ClusterPartition find(Collection<ClusterPartition> partitions, Integer slot) {
        return partitions.stream().filter(p -> p.hasSlot(slot)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find partition with slot " + slot));
    }

    private CompletableFuture<Void> checkMasterNodesChange(ClusterServersConfig cfg, Collection<ClusterPartition> newPartitions) {
        HashMap<RedisURI, ClusterPartition> addedPartitions = new HashMap<RedisURI, ClusterPartition>();
        HashSet<RedisURI> mastersElected = new HashSet<RedisURI>();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (ClusterPartition newPart : newPartitions) {
            boolean masterFound;
            if (newPart.getSlotsAmount() == 0) continue;
            ClusterPartition currentPart = this.lastUri2Partition.get(newPart.getMasterAddress());
            boolean bl = masterFound = currentPart != null;
            if (masterFound && newPart.isMasterFail()) {
                for (Integer slot : currentPart.getSlots()) {
                    ClusterPartition newMasterPart = this.find(newPartitions, slot);
                    if (Objects.equals(newMasterPart.getMasterAddress(), currentPart.getMasterAddress())) continue;
                    RedisURI newUri = newMasterPart.getMasterAddress();
                    RedisURI oldUri = currentPart.getMasterAddress();
                    mastersElected.add(newUri);
                    CompletableFuture<RedisClient> future = this.changeMaster(slot, newUri);
                    currentPart.setMasterAddress(newUri);
                    CompletionStage f = future.whenComplete((res, e) -> {
                        if (e != null) {
                            currentPart.setMasterAddress(oldUri);
                        } else {
                            this.disconnectNode(oldUri);
                        }
                    });
                    futures.add(f);
                }
            }
            if (masterFound || newPart.isMasterFail()) continue;
            addedPartitions.put(newPart.getMasterAddress(), newPart);
        }
        addedPartitions.keySet().removeAll(mastersElected);
        for (ClusterPartition newPart : addedPartitions.values()) {
            CompletionStage<Void> future = this.addMasterEntry(newPart, cfg);
            futures.add(future.toCompletableFuture());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).exceptionally(e -> {
            if (e != null) {
                this.log.error("Unable to add/change master node", (Throwable)e);
            }
            return null;
        });
    }

    private void checkSlotsChange(Collection<ClusterPartition> newPartitions) {
        int newSlotsAmount = newPartitions.stream().mapToInt(ClusterPartition::getSlotsAmount).sum();
        if (newSlotsAmount == this.lastPartitions.size() && this.lastPartitions.size() == 16384) {
            return;
        }
        Set removedSlots = this.lastPartitions.keySet().stream().filter(s -> newPartitions.stream().noneMatch(p -> p.hasSlot((int)s))).collect(Collectors.toSet());
        for (Integer slot : removedSlots) {
            ClusterPartition p = this.lastPartitions.remove(slot);
            if (p != null && p.decReference() == 0 && this.lastUri2Partition.size() > 1) {
                this.lastUri2Partition.remove(p.getMasterAddress());
            }
            this.removeEntry(slot);
        }
        if (!removedSlots.isEmpty()) {
            this.log.info("{} slots removed", (Object)removedSlots.size());
        }
        Integer addedSlots = 0;
        for (ClusterPartition clusterPartition : newPartitions) {
            MasterSlaveEntry entry = this.getEntry(clusterPartition.getMasterAddress());
            for (Integer slot : clusterPartition.getSlots()) {
                if (this.lastPartitions.containsKey(slot) || entry == null) continue;
                this.addEntry(slot, entry);
                this.addPartition(slot, clusterPartition);
                this.lastUri2Partition.put(clusterPartition.getMasterAddress(), clusterPartition);
                Integer n = addedSlots;
                addedSlots = addedSlots + 1;
            }
        }
        if (addedSlots > 0) {
            this.log.info("{} slots added", (Object)addedSlots);
        }
    }

    private void checkSlotsMigration(Collection<ClusterPartition> newPartitions) {
        Collection<ClusterPartition> clusterLastPartitions = this.getLastPartitions();
        Map<String, MasterSlaveEntry> nodeEntries = clusterLastPartitions.stream().collect(Collectors.toMap(p -> p.getNodeId(), p -> this.getEntry(p.getSlotRanges().iterator().next().getStartSlot())));
        HashSet changedSlots = new HashSet();
        block0: for (ClusterPartition currentPartition : clusterLastPartitions) {
            String nodeId = currentPartition.getNodeId();
            for (ClusterPartition newPartition : newPartitions) {
                if (!Objects.equals(nodeId, newPartition.getNodeId()) || newPartition.getSlotRanges().equals(currentPartition.getSlotRanges())) continue;
                MasterSlaveEntry entry = nodeEntries.get(nodeId);
                BitSet addedSlots = newPartition.copySlots();
                addedSlots.andNot(currentPartition.slots());
                addedSlots.stream().forEach(slot -> {
                    this.addEntry(slot, entry);
                    this.addPartition(slot, currentPartition);
                    changedSlots.add(slot);
                });
                if (!addedSlots.isEmpty()) {
                    this.lastUri2Partition.put(currentPartition.getMasterAddress(), currentPartition);
                    this.log.info("{} slots added to {}", (Object)addedSlots.cardinality(), (Object)currentPartition.getMasterAddress());
                }
                BitSet removedSlots = currentPartition.copySlots();
                removedSlots.andNot(newPartition.slots());
                removedSlots.stream().forEach(slot -> {
                    if (this.lastPartitions.remove(slot, currentPartition)) {
                        if (currentPartition.decReference() == 0 && this.lastUri2Partition.size() > 1) {
                            this.lastUri2Partition.remove(currentPartition.getMasterAddress());
                        }
                        this.removeEntry(slot, entry);
                        changedSlots.add(slot);
                    }
                });
                if (!removedSlots.isEmpty()) {
                    this.log.info("{} slots removed from {}", (Object)removedSlots.cardinality(), (Object)currentPartition.getMasterAddress());
                }
                if (addedSlots.isEmpty() && removedSlots.isEmpty()) continue block0;
                currentPartition.updateSlotRanges(newPartition.getSlotRanges(), newPartition.slots());
                continue block0;
            }
        }
        changedSlots.forEach(this.subscribeService::reattachPubSub);
    }

    private int indexOf(byte[] array, byte element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int calcSlot(byte[] key) {
        int end;
        if (key == null) {
            return 0;
        }
        int start = this.indexOf(key, (byte)123);
        if (start != -1 && (end = this.indexOf(key, (byte)125)) != -1 && start + 1 < end) {
            key = Arrays.copyOfRange(key, start + 1, end);
        }
        int result = CRC16.crc16(key) % 16384;
        return result;
    }

    @Override
    public int calcSlot(ByteBuf key) {
        int end;
        if (key == null) {
            return 0;
        }
        int start = key.indexOf(key.readerIndex(), key.readerIndex() + key.readableBytes(), (byte)123);
        if (start != -1 && (end = key.indexOf(start + 1, key.readerIndex() + key.readableBytes(), (byte)125)) != -1 && start + 1 < end) {
            key = key.slice(start + 1, end - start - 1);
        }
        int result = CRC16.crc16(key) % 16384;
        this.log.debug("slot {} for {}", (Object)result, (Object)key);
        return result;
    }

    @Override
    public int calcSlot(String key) {
        int end;
        if (key == null) {
            return 0;
        }
        int start = key.indexOf(123);
        if (start != -1 && (end = key.indexOf(125)) != -1 && start + 1 < end) {
            key = key.substring(start + 1, end);
        }
        int result = CRC16.crc16(key.getBytes()) % 16384;
        this.log.debug("slot {} for {}", (Object)result, (Object)key);
        return result;
    }

    private CompletableFuture<Collection<ClusterPartition>> parsePartitions(List<ClusterNodeInfo> nodes) {
        ConcurrentHashMap partitions = new ConcurrentHashMap();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (ClusterNodeInfo clusterNodeInfo : nodes) {
            String masterId;
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.NOADDR) || clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.HANDSHAKE) || clusterNodeInfo.getAddress() == null || clusterNodeInfo.getSlotRanges().isEmpty() && clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.MASTER) || (masterId = clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE) ? clusterNodeInfo.getSlaveOf() : clusterNodeInfo.getNodeId()) == null) continue;
            RedisURI uri = clusterNodeInfo.getHostName() != null ? new RedisURI(clusterNodeInfo.getAddress().getScheme() + "://" + clusterNodeInfo.getHostName() + ":" + clusterNodeInfo.getAddress().getPort()) : clusterNodeInfo.getAddress();
            CompletableFuture<List<RedisURI>> ipsFuture = this.serviceManager.resolveAll(uri);
            CompletionStage f = ((CompletableFuture)((CompletableFuture)ipsFuture.handle((r, ex) -> {
                if (ex != null) {
                    RedisURI mappedUri = this.serviceManager.toURI(clusterNodeInfo.getAddress().getScheme(), clusterNodeInfo.getAddress().getHost(), "" + clusterNodeInfo.getAddress().getPort());
                    return Collections.singletonList(mappedUri);
                }
                return r;
            })).thenCompose(addresses -> {
                ClusterPartition masterPartition;
                int index = 0;
                if (addresses.size() > 1) {
                    addresses.sort(Comparator.comparing(RedisURI::getHost));
                }
                RedisURI address = (RedisURI)addresses.get(index);
                if (this.configEndpointPassword != null) {
                    address = new RedisURI(address.getScheme() + "://" + this.configEndpointPassword + "@" + address.getHost() + ":" + address.getPort());
                }
                if (addresses.size() > 1) {
                    block0: for (RedisURI addr : addresses) {
                        for (ClusterPartition value : this.lastUri2Partition.values()) {
                            if (!value.getNodeId().equals(clusterNodeInfo.getNodeId()) || !value.getMasterAddress().equals(addr)) continue;
                            address = addr;
                            continue block0;
                        }
                    }
                }
                if (addresses.size() == 1) {
                    if (!uri.equals(address)) {
                        this.log.debug("{} resolved to {}", (Object)uri, (Object)address);
                    }
                } else {
                    this.log.debug("{} resolved to {} and {} selected", uri, addresses, address);
                }
                if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                    masterPartition = partitions.computeIfAbsent(masterId, k -> new ClusterPartition(masterId));
                    ClusterPartition slavePartition = partitions.computeIfAbsent(clusterNodeInfo.getNodeId(), k -> new ClusterPartition(clusterNodeInfo.getNodeId()));
                    slavePartition.setType(ClusterPartition.Type.SLAVE);
                    slavePartition.setParent(masterPartition);
                    masterPartition.addSlaveAddress(address);
                    if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL)) {
                        masterPartition.addFailedSlaveAddress(address);
                    }
                    if (this.cfg.isCheckMasterLinkStatus()) {
                        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(this.cfg, address, this.configEndpointHostName);
                        RedisURI finalAddress = address;
                        return connectionFuture.thenCompose(con -> {
                            RFuture future = con.async(StringCodec.INSTANCE, RedisCommands.INFO_REPLICATION, new Object[0]);
                            return future.handle((info, ex) -> {
                                if (ex != null) {
                                    if (ex instanceof RedisTimeoutException) {
                                        return null;
                                    }
                                    throw new CompletionException((Throwable)ex);
                                }
                                String masterLinkStatus = info.getOrDefault("master_link_status", "");
                                if ("down".equals(masterLinkStatus)) {
                                    masterPartition.addFailedSlaveAddress(finalAddress);
                                }
                                return null;
                            });
                        });
                    }
                    return CompletableFuture.completedFuture(null);
                }
                if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.MASTER)) {
                    masterPartition = partitions.computeIfAbsent(masterId, k -> new ClusterPartition(masterId));
                    masterPartition.setSlotRanges(clusterNodeInfo.getSlotRanges());
                    masterPartition.setMasterAddress(address);
                    masterPartition.setType(ClusterPartition.Type.MASTER);
                    if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL)) {
                        masterPartition.setMasterFail(true);
                    }
                }
                return CompletableFuture.completedFuture(null);
            })).exceptionally(ex -> {
                if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL) || clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.EVENTUAL_FAIL)) {
                    return null;
                }
                this.log.error(ex.getMessage(), (Throwable)ex);
                return null;
            });
            futures.add(f);
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return future.thenApply(r -> {
            this.addCascadeSlaves(partitions.values());
            List ps = partitions.values().stream().filter(cp -> cp.getType() == ClusterPartition.Type.MASTER && cp.getMasterAddress() != null && (!cp.slots().isEmpty() && partitions.size() == 1 || partitions.size() > 1)).collect(Collectors.toList());
            return ps;
        });
    }

    private void addCascadeSlaves(Collection<ClusterPartition> partitions) {
        Iterator<ClusterPartition> iter = partitions.iterator();
        while (iter.hasNext()) {
            ClusterPartition cp = iter.next();
            if (cp.getType() != ClusterPartition.Type.SLAVE) continue;
            if (cp.getParent() != null && cp.getParent().getType() == ClusterPartition.Type.MASTER) {
                ClusterPartition parent = cp.getParent();
                for (RedisURI addr : cp.getSlaveAddresses()) {
                    parent.addSlaveAddress(addr);
                }
                for (RedisURI addr : cp.getFailedSlaveAddresses()) {
                    parent.addFailedSlaveAddress(addr);
                }
            }
            iter.remove();
        }
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel();
        }
        this.closeNodeConnections();
        super.shutdown(quietPeriod, timeout, unit);
    }

    private Collection<ClusterPartition> getLastPartitions() {
        return this.lastUri2Partition.values().stream().collect(Collectors.toMap(e -> e.getNodeId(), Function.identity(), BinaryOperator.maxBy(Comparator.comparing(e -> e.getTime())))).values();
    }

    public int getSlot(MasterSlaveEntry entry) {
        return this.lastPartitions.entrySet().stream().filter(e -> ((ClusterPartition)e.getValue()).getMasterAddress().equals(entry.getClient().getConfig().getAddress())).findAny().map(m -> (Integer)m.getKey()).orElse(-1);
    }

    @Override
    public RedisURI getLastClusterNode() {
        return this.lastClusterNode;
    }
}

