/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.redisson.client.FailedNodeDetector;

public class FailedCommandsDetector
implements FailedNodeDetector {
    private long checkInterval;
    private long failedCommandsLimit;
    private final NavigableSet<Long> failedCommands = new ConcurrentSkipListSet<Long>();

    public FailedCommandsDetector() {
    }

    public FailedCommandsDetector(long checkInterval, int failedCommandsLimit) {
        if (checkInterval == 0L) {
            throw new IllegalArgumentException("checkInterval value");
        }
        if (failedCommandsLimit == 0) {
            throw new IllegalArgumentException("failedCommandsLimit value");
        }
        this.checkInterval = checkInterval;
        this.failedCommandsLimit = failedCommandsLimit;
    }

    public void setCheckInterval(long checkInterval) {
        if (checkInterval == 0L) {
            throw new IllegalArgumentException("checkInterval value");
        }
        this.checkInterval = checkInterval;
    }

    public void setFailedCommandsLimit(long failedCommandsLimit) {
        if (failedCommandsLimit == 0L) {
            throw new IllegalArgumentException("failedCommandsLimit value");
        }
        this.failedCommandsLimit = failedCommandsLimit;
    }

    @Override
    public void onConnectFailed() {
    }

    @Override
    public void onConnectFailed(Throwable cause) {
    }

    @Override
    public void onConnectSuccessful() {
    }

    @Override
    public void onPingSuccessful() {
    }

    @Override
    public void onCommandSuccessful() {
    }

    @Override
    public void onPingFailed() {
    }

    @Override
    public void onPingFailed(Throwable cause) {
    }

    @Override
    public void onCommandFailed(Throwable cause) {
        this.failedCommands.add(System.currentTimeMillis());
    }

    @Override
    public boolean isNodeFailed() {
        if (this.failedCommandsLimit == 0L) {
            throw new IllegalArgumentException("failedCommandsLimit isn't set");
        }
        long start = System.currentTimeMillis() - this.checkInterval;
        this.failedCommands.headSet(start).clear();
        if ((long)this.failedCommands.tailSet(start).size() >= this.failedCommandsLimit) {
            this.failedCommands.clear();
            return true;
        }
        return false;
    }
}

